/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.base.math.NonNegativeQuantity;
import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.identifier.metafields.FieldWithMetaIdentifier;
import cdm.base.staticdata.party.PartyReferencePayerReceiver;
import cdm.event.common.Reset;
import cdm.event.common.SettlementOrigin;
import cdm.event.common.TransferBase;
import cdm.event.common.TransferExpression;
import cdm.event.common.meta.TransferMeta;
import cdm.observable.asset.Observable;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Transfer", builder=TransferBuilderImpl.class, version="5.0.0")
public interface Transfer
extends TransferBase {
    public static final TransferMeta metaData = new TransferMeta();

    public SettlementOrigin getSettlementOrigin();

    public Reset getResetOrigin();

    public TransferExpression getTransferExpression();

    @Override
    public Transfer build();

    @Override
    public TransferBuilder toBuilder();

    public static TransferBuilder builder() {
        return new TransferBuilderImpl();
    }

    default public RosettaMetaData<? extends Transfer> metaData() {
        return metaData;
    }

    default public Class<? extends Transfer> getType() {
        return Transfer.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        TransferBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("settlementOrigin"), processor, SettlementOrigin.class, this.getSettlementOrigin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("resetOrigin"), processor, Reset.class, this.getResetOrigin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("transferExpression"), processor, TransferExpression.class, this.getTransferExpression(), new AttributeMeta[0]);
    }

    public static class TransferBuilderImpl
    extends TransferBase.TransferBaseBuilderImpl
    implements TransferBuilder {
        protected SettlementOrigin.SettlementOriginBuilder settlementOrigin;
        protected Reset.ResetBuilder resetOrigin;
        protected TransferExpression.TransferExpressionBuilder transferExpression;

        @Override
        @RosettaAttribute(value="settlementOrigin")
        public SettlementOrigin.SettlementOriginBuilder getSettlementOrigin() {
            return this.settlementOrigin;
        }

        @Override
        public SettlementOrigin.SettlementOriginBuilder getOrCreateSettlementOrigin() {
            SettlementOrigin.SettlementOriginBuilder result = this.settlementOrigin != null ? this.settlementOrigin : (this.settlementOrigin = SettlementOrigin.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="resetOrigin")
        public Reset.ResetBuilder getResetOrigin() {
            return this.resetOrigin;
        }

        @Override
        public Reset.ResetBuilder getOrCreateResetOrigin() {
            Reset.ResetBuilder result = this.resetOrigin != null ? this.resetOrigin : (this.resetOrigin = Reset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="transferExpression")
        public TransferExpression.TransferExpressionBuilder getTransferExpression() {
            return this.transferExpression;
        }

        @Override
        public TransferExpression.TransferExpressionBuilder getOrCreateTransferExpression() {
            TransferExpression.TransferExpressionBuilder result = this.transferExpression != null ? this.transferExpression : (this.transferExpression = TransferExpression.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementOrigin")
        public TransferBuilder setSettlementOrigin(SettlementOrigin settlementOrigin) {
            this.settlementOrigin = settlementOrigin == null ? null : settlementOrigin.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="resetOrigin")
        public TransferBuilder setResetOrigin(Reset resetOrigin) {
            this.resetOrigin = resetOrigin == null ? null : resetOrigin.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="transferExpression")
        public TransferBuilder setTransferExpression(TransferExpression transferExpression) {
            this.transferExpression = transferExpression == null ? null : transferExpression.toBuilder();
            return this;
        }

        @Override
        public TransferBuilder addIdentifier(FieldWithMetaIdentifier identifier) {
            if (identifier != null) {
                this.identifier.add(identifier.toBuilder());
            }
            return this;
        }

        @Override
        public TransferBuilder addIdentifier(FieldWithMetaIdentifier identifier, int _idx) {
            this.getIndex(this.identifier, _idx, () -> identifier.toBuilder());
            return this;
        }

        @Override
        public TransferBuilder addIdentifierValue(Identifier identifier) {
            this.getOrCreateIdentifier(-1).setValue(identifier.toBuilder());
            return this;
        }

        @Override
        public TransferBuilder addIdentifierValue(Identifier identifier, int _idx) {
            this.getOrCreateIdentifier(_idx).setValue(identifier.toBuilder());
            return this;
        }

        @Override
        public TransferBuilder addIdentifier(List<? extends FieldWithMetaIdentifier> identifiers) {
            if (identifiers != null) {
                for (FieldWithMetaIdentifier fieldWithMetaIdentifier : identifiers) {
                    this.identifier.add(fieldWithMetaIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="identifier")
        public TransferBuilder setIdentifier(List<? extends FieldWithMetaIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TransferBuilder addIdentifierValue(List<? extends Identifier> identifiers) {
            if (identifiers != null) {
                for (Identifier identifier : identifiers) {
                    this.addIdentifierValue(identifier);
                }
            }
            return this;
        }

        @Override
        public TransferBuilder setIdentifierValue(List<? extends Identifier> identifiers) {
            this.identifier.clear();
            if (identifiers != null) {
                identifiers.forEach(this::addIdentifierValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="quantity")
        public TransferBuilder setQuantity(NonNegativeQuantity quantity) {
            this.quantity = quantity == null ? null : quantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observable")
        public TransferBuilder setObservable(Observable observable) {
            this.observable = observable == null ? null : observable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        public TransferBuilder setPayerReceiver(PartyReferencePayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        public TransferBuilder setSettlementDate(AdjustableOrAdjustedOrRelativeDate settlementDate) {
            this.settlementDate = settlementDate == null ? null : settlementDate.toBuilder();
            return this;
        }

        @Override
        public Transfer build() {
            return new TransferImpl(this);
        }

        @Override
        public TransferBuilder toBuilder() {
            return this;
        }

        @Override
        public TransferBuilder prune() {
            super.prune();
            if (this.settlementOrigin != null && !this.settlementOrigin.prune().hasData()) {
                this.settlementOrigin = null;
            }
            if (this.resetOrigin != null && !this.resetOrigin.prune().hasData()) {
                this.resetOrigin = null;
            }
            if (this.transferExpression != null && !this.transferExpression.prune().hasData()) {
                this.transferExpression = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSettlementOrigin() != null && this.getSettlementOrigin().hasData()) {
                return true;
            }
            if (this.getResetOrigin() != null && this.getResetOrigin().hasData()) {
                return true;
            }
            return this.getTransferExpression() != null && this.getTransferExpression().hasData();
        }

        @Override
        public TransferBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            TransferBuilder o = (TransferBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementOrigin(), (RosettaModelObjectBuilder)o.getSettlementOrigin(), this::setSettlementOrigin);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getResetOrigin(), (RosettaModelObjectBuilder)o.getResetOrigin(), this::setResetOrigin);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTransferExpression(), (RosettaModelObjectBuilder)o.getTransferExpression(), this::setTransferExpression);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Transfer _that = (Transfer)this.getType().cast(o);
            if (!Objects.equals(this.settlementOrigin, _that.getSettlementOrigin())) {
                return false;
            }
            if (!Objects.equals(this.resetOrigin, _that.getResetOrigin())) {
                return false;
            }
            return Objects.equals(this.transferExpression, _that.getTransferExpression());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementOrigin != null ? this.settlementOrigin.hashCode() : 0);
            _result = 31 * _result + (this.resetOrigin != null ? this.resetOrigin.hashCode() : 0);
            _result = 31 * _result + (this.transferExpression != null ? this.transferExpression.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TransferBuilder {settlementOrigin=" + this.settlementOrigin + ", resetOrigin=" + this.resetOrigin + ", transferExpression=" + this.transferExpression + '}' + " " + super.toString();
        }
    }

    public static class TransferImpl
    extends TransferBase.TransferBaseImpl
    implements Transfer {
        private final SettlementOrigin settlementOrigin;
        private final Reset resetOrigin;
        private final TransferExpression transferExpression;

        protected TransferImpl(TransferBuilder builder) {
            super(builder);
            this.settlementOrigin = Optional.ofNullable(builder.getSettlementOrigin()).map(f -> f.build()).orElse(null);
            this.resetOrigin = Optional.ofNullable(builder.getResetOrigin()).map(f -> f.build()).orElse(null);
            this.transferExpression = Optional.ofNullable(builder.getTransferExpression()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementOrigin")
        public SettlementOrigin getSettlementOrigin() {
            return this.settlementOrigin;
        }

        @Override
        @RosettaAttribute(value="resetOrigin")
        public Reset getResetOrigin() {
            return this.resetOrigin;
        }

        @Override
        @RosettaAttribute(value="transferExpression")
        public TransferExpression getTransferExpression() {
            return this.transferExpression;
        }

        @Override
        public Transfer build() {
            return this;
        }

        @Override
        public TransferBuilder toBuilder() {
            TransferBuilder builder = Transfer.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TransferBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSettlementOrigin()).ifPresent(builder::setSettlementOrigin);
            Optional.ofNullable(this.getResetOrigin()).ifPresent(builder::setResetOrigin);
            Optional.ofNullable(this.getTransferExpression()).ifPresent(builder::setTransferExpression);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Transfer _that = (Transfer)this.getType().cast(o);
            if (!Objects.equals(this.settlementOrigin, _that.getSettlementOrigin())) {
                return false;
            }
            if (!Objects.equals(this.resetOrigin, _that.getResetOrigin())) {
                return false;
            }
            return Objects.equals(this.transferExpression, _that.getTransferExpression());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementOrigin != null ? this.settlementOrigin.hashCode() : 0);
            _result = 31 * _result + (this.resetOrigin != null ? this.resetOrigin.hashCode() : 0);
            _result = 31 * _result + (this.transferExpression != null ? this.transferExpression.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Transfer {settlementOrigin=" + this.settlementOrigin + ", resetOrigin=" + this.resetOrigin + ", transferExpression=" + this.transferExpression + '}' + " " + super.toString();
        }
    }

    public static interface TransferBuilder
    extends Transfer,
    TransferBase.TransferBaseBuilder,
    RosettaModelObjectBuilder {
        public SettlementOrigin.SettlementOriginBuilder getOrCreateSettlementOrigin();

        @Override
        public SettlementOrigin.SettlementOriginBuilder getSettlementOrigin();

        public Reset.ResetBuilder getOrCreateResetOrigin();

        @Override
        public Reset.ResetBuilder getResetOrigin();

        public TransferExpression.TransferExpressionBuilder getOrCreateTransferExpression();

        @Override
        public TransferExpression.TransferExpressionBuilder getTransferExpression();

        public TransferBuilder setSettlementOrigin(SettlementOrigin var1);

        public TransferBuilder setResetOrigin(Reset var1);

        public TransferBuilder setTransferExpression(TransferExpression var1);

        @Override
        public TransferBuilder addIdentifier(FieldWithMetaIdentifier var1);

        @Override
        public TransferBuilder addIdentifier(FieldWithMetaIdentifier var1, int var2);

        @Override
        public TransferBuilder addIdentifierValue(Identifier var1);

        @Override
        public TransferBuilder addIdentifierValue(Identifier var1, int var2);

        @Override
        public TransferBuilder addIdentifier(List<? extends FieldWithMetaIdentifier> var1);

        @Override
        public TransferBuilder setIdentifier(List<? extends FieldWithMetaIdentifier> var1);

        @Override
        public TransferBuilder addIdentifierValue(List<? extends Identifier> var1);

        @Override
        public TransferBuilder setIdentifierValue(List<? extends Identifier> var1);

        @Override
        public TransferBuilder setQuantity(NonNegativeQuantity var1);

        @Override
        public TransferBuilder setObservable(Observable var1);

        @Override
        public TransferBuilder setPayerReceiver(PartyReferencePayerReceiver var1);

        @Override
        public TransferBuilder setSettlementDate(AdjustableOrAdjustedOrRelativeDate var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            TransferBase.TransferBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("settlementOrigin"), processor, SettlementOrigin.SettlementOriginBuilder.class, this.getSettlementOrigin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("resetOrigin"), processor, Reset.ResetBuilder.class, this.getResetOrigin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("transferExpression"), processor, TransferExpression.TransferExpressionBuilder.class, this.getTransferExpression(), new AttributeMeta[0]);
        }

        @Override
        public TransferBuilder prune();
    }
}

