/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party.processor;

import com.google.common.collect.MoreCollectors;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class TradeSideToPartyMappingHelper
implements Function<String, Optional<String>> {
    private static final Path RELATIVE_PATH = Path.parse((String)"orderer.party.href");
    private final List<Mapping> mappings;

    public TradeSideToPartyMappingHelper(List<Mapping> mappings) {
        this.mappings = mappings;
    }

    @Override
    public Optional<String> apply(String tradeSideId) {
        Stream<Path> partyPath = this.mappings.stream().filter(m -> this.matches((Mapping)m, tradeSideId)).map(Mapping::getXmlPath).map(Path::getParent).map(p -> p.append(RELATIVE_PATH));
        Optional newValue = (Optional)partyPath.map(this::extractXmlValueFromMappings).distinct().collect(MoreCollectors.onlyElement());
        return newValue;
    }

    private Optional<String> extractXmlValueFromMappings(Path partyPath) {
        return (Optional)this.mappings.stream().filter(p -> partyPath.nameIndexMatches(p.getXmlPath())).map(Mapping::getXmlValue).map(String::valueOf).collect(MoreCollectors.toOptional());
    }

    private boolean matches(Mapping mapping, String tradeSideId) {
        return mapping.getXmlPath().endsWith(new String[]{"id"}) && String.valueOf(mapping.getXmlValue()).equals(tradeSideId);
    }
}

