/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="ProductTaxonomyTaxonomySource")
@ImplementedBy(value=Default.class)
public interface ProductTaxonomyTaxonomySource
extends Validator<ProductTaxonomy> {
    public static final String NAME = "ProductTaxonomyTaxonomySource";
    public static final String DEFINITION = "if source exists then (value exists or productQualifier exists)";

    public ValidationResult<ProductTaxonomy> validate(RosettaPath var1, ProductTaxonomy var2);

    public static class NoOp
    implements ProductTaxonomyTaxonomySource {
        @Override
        public ValidationResult<ProductTaxonomy> validate(RosettaPath path, ProductTaxonomy productTaxonomy) {
            return ValidationResult.success((String)ProductTaxonomyTaxonomySource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ProductTaxonomy", (RosettaPath)path, (String)ProductTaxonomyTaxonomySource.DEFINITION);
        }
    }

    public static class Default
    implements ProductTaxonomyTaxonomySource {
        @Override
        public ValidationResult<ProductTaxonomy> validate(RosettaPath path, ProductTaxonomy productTaxonomy) {
            ComparisonResult result = this.executeDataRule(productTaxonomy);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ProductTaxonomyTaxonomySource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ProductTaxonomy", (RosettaPath)path, (String)ProductTaxonomyTaxonomySource.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ProductTaxonomyTaxonomySource failed.";
            }
            return ValidationResult.failure((String)ProductTaxonomyTaxonomySource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ProductTaxonomy", (RosettaPath)path, (String)ProductTaxonomyTaxonomySource.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(ProductTaxonomy productTaxonomy) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)productTaxonomy).map("getSource", taxonomy -> taxonomy.getSource())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)productTaxonomy).map("getValue", taxonomy -> taxonomy.getValue())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)productTaxonomy).map("getProductQualifier", _productTaxonomy -> _productTaxonomy.getProductQualifier())));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

