/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.meta.DateListMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DateList", builder=DateListBuilderImpl.class, version="5.0.0")
public interface DateList
extends RosettaModelObject {
    public static final DateListMeta metaData = new DateListMeta();

    public List<Date> getDate();

    public DateList build();

    public DateListBuilder toBuilder();

    public static DateListBuilder builder() {
        return new DateListBuilderImpl();
    }

    default public RosettaMetaData<? extends DateList> metaData() {
        return metaData;
    }

    default public Class<? extends DateList> getType() {
        return DateList.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("date"), Date.class, this.getDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DateListBuilderImpl
    implements DateListBuilder {
        protected List<Date> date = new ArrayList<Date>();

        @Override
        @RosettaAttribute(value="date")
        public List<Date> getDate() {
            return this.date;
        }

        @Override
        public DateListBuilder addDate(Date date) {
            if (date != null) {
                this.date.add(date);
            }
            return this;
        }

        @Override
        public DateListBuilder addDate(Date date, int _idx) {
            this.getIndex(this.date, _idx, () -> date);
            return this;
        }

        @Override
        public DateListBuilder addDate(List<? extends Date> dates) {
            if (dates != null) {
                for (Date date : dates) {
                    this.date.add(date);
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="date")
        public DateListBuilder setDate(List<? extends Date> dates) {
            this.date = dates == null ? new ArrayList<Date>() : (List)dates.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public DateList build() {
            return new DateListImpl(this);
        }

        @Override
        public DateListBuilder toBuilder() {
            return this;
        }

        @Override
        public DateListBuilder prune() {
            return this;
        }

        public boolean hasData() {
            return this.getDate() != null && !this.getDate().isEmpty();
        }

        public DateListBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DateListBuilder o = (DateListBuilder)other;
            merger.mergeBasic(this.getDate(), o.getDate(), this::addDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DateList _that = this.getType().cast(o);
            return ListEquals.listEquals(this.date, _that.getDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DateListBuilder {date=" + this.date + '}';
        }
    }

    public static class DateListImpl
    implements DateList {
        private final List<Date> date;

        protected DateListImpl(DateListBuilder builder) {
            this.date = Optional.ofNullable(builder.getDate()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="date")
        public List<Date> getDate() {
            return this.date;
        }

        @Override
        public DateList build() {
            return this;
        }

        @Override
        public DateListBuilder toBuilder() {
            DateListBuilder builder = DateList.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DateListBuilder builder) {
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DateList _that = this.getType().cast(o);
            return ListEquals.listEquals(this.date, _that.getDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DateList {date=" + this.date + '}';
        }
    }

    public static interface DateListBuilder
    extends DateList,
    RosettaModelObjectBuilder {
        public DateListBuilder addDate(Date var1);

        public DateListBuilder addDate(Date var1, int var2);

        public DateListBuilder addDate(List<? extends Date> var1);

        public DateListBuilder setDate(List<? extends Date> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("date"), Date.class, this.getDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public DateListBuilder prune();
    }
}

