# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['MasterAgreementVariableSet']


class MasterAgreementVariableSet(BaseDataClass):
  """
  Defines a type where additional variables associated to clauses and their variants can be described.
  """
  variableSet: List[MasterAgreementVariableSet] = Field([], description="For some variants a table of variables is required. To support this use case we need to be able to specify variables within variables. Including a variable set here gives us infinite nesting opportunities - realistically we are only ever expecting that a table would need to be defined for any particular clause, so we would expect two levels of nesting as a maximum i.e. variableSet->variableSet->name/value.")
  """
  For some variants a table of variables is required. To support this use case we need to be able to specify variables within variables. Including a variable set here gives us infinite nesting opportunities - realistically we are only ever expecting that a table would need to be defined for any particular clause, so we would expect two levels of nesting as a maximum i.e. variableSet->variableSet->name/value.
  """
  name: Optional[str] = Field(None, description="The name of the variable")
  """
  The name of the variable
  """
  value: Optional[str] = Field(None, description="The value for this variable")
  """
  The value for this variable
  """
  
  @rosetta_condition
  def condition_0_VariableSetExists(self):
    """
    If we have a variableSet then we must not have any name/value pairs at this level.
    """
    def _then_fn0():
      return (((_resolve_rosetta_attr(self, "name")) is None) and ((_resolve_rosetta_attr(self, "value")) is None))
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "variableSet")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_1_VariableSetNesting(self):
    """
    We are only allowing two levels of nesting of variableSet for the time being. This is because we only need to support tables of data in the master agreement variants. This condition can be modified or deleted if we find we need more levels of nesting.
    """
    def _then_fn0():
      return ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "variableSet"), "variableSet"), "variableSet")) is None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "variableSet"), "variableSet")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_2_NameMustExist(self):
    """
    If we have a name then we must also have a value.
    """
    def _then_fn0():
      return ((_resolve_rosetta_attr(self, "value")) is not None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "name")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_3_ValueMustExist(self):
    """
    If we have a value then we must also have a name.
    """
    def _then_fn0():
      return ((_resolve_rosetta_attr(self, "name")) is not None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "value")) is not None), _then_fn0, _else_fn0)

from cdm.legaldocumentation.master.MasterAgreementVariableSet import MasterAgreementVariableSet

MasterAgreementVariableSet.update_forward_refs()
