package cdm.product.collateral.validation;

import cdm.base.datetime.DayTypeEnum;
import cdm.product.collateral.CollateralInterestNotification;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.time.LocalTime;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CollateralInterestNotificationValidator implements Validator<CollateralInterestNotification> {

	@Override
	public ValidationResult<CollateralInterestNotification> validate(RosettaPath path, CollateralInterestNotification o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("trigger", (String) o.getTrigger() != null ? 1 : 0, 1, 1), 
				checkCardinality("offset", (BigDecimal) o.getOffset() != null ? 1 : 0, 1, 1), 
				checkCardinality("notificationTime", (LocalTime) o.getNotificationTime() != null ? 1 : 0, 1, 1), 
				checkCardinality("notificationDayType", (DayTypeEnum) o.getNotificationDayType() != null ? 1 : 0, 1, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CollateralInterestNotification", ValidationType.CARDINALITY, "CollateralInterestNotification", path, "", error);
		}
		return success("CollateralInterestNotification", ValidationType.CARDINALITY, "CollateralInterestNotification", path, "");
	}

}
