package cdm.product.collateral.functions;

import cdm.base.math.QuantifierEnum;
import cdm.observable.asset.CreditNotation;
import cdm.observable.asset.CreditRatingAgencyEnum;
import cdm.product.collateral.AgencyRatingCriteria;
import cdm.product.collateral.EligibilityQuery;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CheckAgencyRating.CheckAgencyRatingDefault.class)
public abstract class CheckAgencyRating implements RosettaFunction {

	/**
	* @param agencyRatings 
	* @param query 
	* @return isEqual 
	*/
	public Boolean evaluate(List<? extends AgencyRatingCriteria> agencyRatings, EligibilityQuery query) {
		Boolean isEqual = doEvaluate(agencyRatings, query);
		
		return isEqual;
	}

	protected abstract Boolean doEvaluate(List<? extends AgencyRatingCriteria> agencyRatings, EligibilityQuery query);

	public static class CheckAgencyRatingDefault extends CheckAgencyRating {
		@Override
		protected Boolean doEvaluate(List<? extends AgencyRatingCriteria> agencyRatings, EligibilityQuery query) {
			Boolean isEqual = null;
			return assignOutput(isEqual, agencyRatings, query);
		}
		
		protected Boolean assignOutput(Boolean isEqual, List<? extends AgencyRatingCriteria> agencyRatings, EligibilityQuery query) {
			isEqual = notExists(MapperC.<AgencyRatingCriteria>of(agencyRatings)).or(ComparisonResult.of(MapperC.<AgencyRatingCriteria>of(agencyRatings)
				.apply(item -> item
					.filterItemNullSafe(_item -> (Boolean)contains(_item.<CreditNotation>mapC("getCreditNotation", agencyRatingCriteria -> agencyRatingCriteria.getCreditNotation()).<FieldWithMetaString>map("getNotation", creditNotation -> creditNotation.getNotation()).<String>map("getValue", _f->_f.getValue()), MapperS.of(query).<AgencyRatingCriteria>map("getAgencyRating", eligibilityQuery -> eligibilityQuery.getAgencyRating()).<CreditNotation>mapC("getCreditNotation", agencyRatingCriteria -> agencyRatingCriteria.getCreditNotation()).<FieldWithMetaString>map("getNotation", creditNotation -> creditNotation.getNotation()).<String>map("getValue", _f->_f.getValue())).get()))
				.apply(item -> item
					.filterItemNullSafe(_item -> (Boolean)contains(_item.<QuantifierEnum>map("getQualifier", agencyRatingCriteria -> agencyRatingCriteria.getQualifier()), MapperS.of(query).<AgencyRatingCriteria>map("getAgencyRating", eligibilityQuery -> eligibilityQuery.getAgencyRating()).<QuantifierEnum>map("getQualifier", agencyRatingCriteria -> agencyRatingCriteria.getQualifier())).get()))
				.apply(item -> item
					.filterItemNullSafe(_item -> (Boolean)notExists(_item.<CreditRatingAgencyEnum>map("getReferenceAgency", agencyRatingCriteria -> agencyRatingCriteria.getReferenceAgency())).or(contains(_item.<CreditRatingAgencyEnum>map("getReferenceAgency", agencyRatingCriteria -> agencyRatingCriteria.getReferenceAgency()), MapperS.of(query).<AgencyRatingCriteria>map("getAgencyRating", eligibilityQuery -> eligibilityQuery.getAgencyRating()).<CreditRatingAgencyEnum>map("getReferenceAgency", agencyRatingCriteria -> agencyRatingCriteria.getReferenceAgency()))).get()))
				.apply(item -> exists(item).asMapper()))).get();
			
			return isEqual;
		}
	}
}
