package cdm.product.asset.validation;

import cdm.base.datetime.metafields.ReferenceWithMetaAdjustableOrRelativeDate;
import cdm.product.asset.DividendDateReference;
import cdm.product.asset.DividendPaymentDate;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class DividendPaymentDateValidator implements Validator<DividendPaymentDate> {

	@Override
	public ValidationResult<DividendPaymentDate> validate(RosettaPath path, DividendPaymentDate o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("dividendDateReference", (DividendDateReference) o.getDividendDateReference() != null ? 1 : 0, 0, 1), 
				checkCardinality("dividendDate", (ReferenceWithMetaAdjustableOrRelativeDate) o.getDividendDate() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("DividendPaymentDate", ValidationType.CARDINALITY, "DividendPaymentDate", path, "", error);
		}
		return success("DividendPaymentDate", ValidationType.CARDINALITY, "DividendPaymentDate", path, "");
	}

}
