package cdm.observable.event.validation;

import cdm.observable.event.FeaturePayment;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class FeaturePaymentTypeFormatValidator implements Validator<FeaturePayment> {

	@Override
	public ValidationResult<FeaturePayment> validate(RosettaPath path, FeaturePayment o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("FeaturePayment", ValidationType.TYPE_FORMAT, "FeaturePayment", path, "", error);
		}
		return success("FeaturePayment", ValidationType.TYPE_FORMAT, "FeaturePayment", path, "");
	}

}
