package cdm.observable.asset.validation;

import cdm.observable.asset.QuoteBasisEnum;
import cdm.observable.asset.QuotedCurrencyPair;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.metafields.FieldWithMetaString;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class QuotedCurrencyPairValidator implements Validator<QuotedCurrencyPair> {

	@Override
	public ValidationResult<QuotedCurrencyPair> validate(RosettaPath path, QuotedCurrencyPair o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("currency1", (FieldWithMetaString) o.getCurrency1() != null ? 1 : 0, 1, 1), 
				checkCardinality("currency2", (FieldWithMetaString) o.getCurrency2() != null ? 1 : 0, 1, 1), 
				checkCardinality("quoteBasis", (QuoteBasisEnum) o.getQuoteBasis() != null ? 1 : 0, 1, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("QuotedCurrencyPair", ValidationType.CARDINALITY, "QuotedCurrencyPair", path, "", error);
		}
		return success("QuotedCurrencyPair", ValidationType.CARDINALITY, "QuotedCurrencyPair", path, "");
	}

}
