package cdm.legaldocumentation.master.validation;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.legaldocumentation.master.MasterAgreementClauseVariant;
import cdm.legaldocumentation.master.MasterAgreementVariantIdentifierEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class MasterAgreementClauseVariantValidator implements Validator<MasterAgreementClauseVariant> {

	@Override
	public ValidationResult<MasterAgreementClauseVariant> validate(RosettaPath path, MasterAgreementClauseVariant o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("identifier", (MasterAgreementVariantIdentifierEnum) o.getIdentifier() != null ? 1 : 0, 1, 1), 
				checkCardinality("name", (String) o.getName() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty", (List<CounterpartyRoleEnum>) o.getCounterparty() == null ? 0 : ((List<CounterpartyRoleEnum>) o.getCounterparty()).size(), 0, 2)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("MasterAgreementClauseVariant", ValidationType.CARDINALITY, "MasterAgreementClauseVariant", path, "", error);
		}
		return success("MasterAgreementClauseVariant", ValidationType.CARDINALITY, "MasterAgreementClauseVariant", path, "");
	}

}
