package cdm.legaldocumentation.common.validation;

import cdm.legaldocumentation.common.ContractualMatrix;
import cdm.legaldocumentation.common.metafields.FieldWithMetaMatrixTermEnum;
import cdm.legaldocumentation.common.metafields.FieldWithMetaMatrixTypeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ContractualMatrixValidator implements Validator<ContractualMatrix> {

	@Override
	public ValidationResult<ContractualMatrix> validate(RosettaPath path, ContractualMatrix o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("matrixType", (FieldWithMetaMatrixTypeEnum) o.getMatrixType() != null ? 1 : 0, 1, 1), 
				checkCardinality("matrixTerm", (FieldWithMetaMatrixTermEnum) o.getMatrixTerm() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("ContractualMatrix", ValidationType.CARDINALITY, "ContractualMatrix", path, "", error);
		}
		return success("ContractualMatrix", ValidationType.CARDINALITY, "ContractualMatrix", path, "");
	}

}
