package cdm.event.position.validation;

import cdm.event.position.InventoryRecord;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class InventoryRecordTypeFormatValidator implements Validator<InventoryRecord> {

	@Override
	public ValidationResult<InventoryRecord> validate(RosettaPath path, InventoryRecord o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("InventoryRecord", ValidationType.TYPE_FORMAT, "InventoryRecord", path, "", error);
		}
		return success("InventoryRecord", ValidationType.TYPE_FORMAT, "InventoryRecord", path, "");
	}

}
