package cdm.event.common.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.CollateralPortfolio;
import cdm.event.common.CollateralPosition;
import cdm.event.common.Reset;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.event.common.Transfer.TransferBuilder;
import cdm.event.common.metafields.ReferenceWithMetaCollateralPortfolio;
import cdm.observable.asset.Price;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.asset.functions.FixedAmount;
import cdm.product.asset.functions.FloatingAmount;
import cdm.product.collateral.Collateral;
import cdm.product.collateral.CollateralProvisions;
import cdm.product.collateral.CollateralTreatment;
import cdm.product.collateral.CollateralValuationTreatment;
import cdm.product.collateral.EligibleCollateralCriteria;
import cdm.product.common.schedule.CalculationPeriodData;
import cdm.product.common.schedule.functions.CalculationPeriodRange;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.AssetPayout;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ResolveSecurityFinanceBillingAmount.ResolveSecurityFinanceBillingAmountDefault.class)
public abstract class ResolveSecurityFinanceBillingAmount implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CalculationPeriodRange calculationPeriodRange0;
	@Inject protected ExtractCounterpartyByRole extractCounterpartyByRole;
	@Inject protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;
	@Inject protected FixedAmount fixedAmount;
	@Inject protected FloatingAmount floatingAmount;

	/**
	* @param tradeState 
	* @param reset 
	* @param recordStartDate 
	* @param recordEndDate 
	* @param transferDate 
	* @return transfer 
	*/
	public Transfer evaluate(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
		Transfer.TransferBuilder transferBuilder = doEvaluate(tradeState, reset, recordStartDate, recordEndDate, transferDate);
		
		final Transfer transfer;
		if (transferBuilder == null) {
			transfer = null;
		} else {
			transfer = transferBuilder.build();
			objectValidator.validate(Transfer.class, transfer);
		}
		
		return transfer;
	}

	protected abstract Transfer.TransferBuilder doEvaluate(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<? extends QuantitySchedule> securityQuantity(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<? extends InterestRatePayout> interestRatePayout(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<? extends AssetPayout> assetPayout(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<? extends Collateral> collateral(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<BigDecimal> haircutPercentage(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<BigDecimal> valuationPercentage(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<BigDecimal> marginRatio(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<BigDecimal> billingQuantity(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<? extends CalculationPeriodData> calculationPeriodRange1(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<BigDecimal> performance(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<? extends Party> payerPartyReference(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	protected abstract Mapper<? extends Party> receiverPartyReference(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate);

	public static class ResolveSecurityFinanceBillingAmountDefault extends ResolveSecurityFinanceBillingAmount {
		@Override
		protected Transfer.TransferBuilder doEvaluate(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			Transfer.TransferBuilder transfer = Transfer.builder();
			return assignOutput(transfer, tradeState, reset, recordStartDate, recordEndDate, transferDate);
		}
		
		protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder transfer, TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			transfer
				.getOrCreateQuantity()
				.setValue(MapperS.of(performance(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).get());
			
			transfer
				.getOrCreateQuantity()
				.getOrCreateUnit()
				.setCurrencyValue(MapperS.of(interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).<ResolvablePriceQuantity>map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("getValue", _f->_f.getValue()).<UnitType>map("getUnit", measureBase -> measureBase.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).<String>map("getValue", _f->_f.getValue()).get());
			
			transfer
				.getOrCreatePayerReceiver()
				.setPayerPartyReferenceValue(MapperUtils.runSinglePolymorphic(() -> {
					if (greaterThanEquals(MapperS.of(performance(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()), MapperS.of(Integer.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(payerPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get());
					}
					else {
						return MapperS.of(receiverPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get());
					}
				}).get());
			
			transfer
				.getOrCreatePayerReceiver()
				.setReceiverPartyReferenceValue(MapperUtils.runSinglePolymorphic(() -> {
					if (greaterThanEquals(MapperS.of(performance(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()), MapperS.of(Integer.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(receiverPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get());
					}
					else {
						return MapperS.of(payerPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get());
					}
				}).get());
			
			transfer
				.getOrCreateSettlementDate()
				.setAdjustedDateValue(MapperS.of(transferDate).get());
			
			return Optional.ofNullable(transfer)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected Mapper<? extends QuantitySchedule> securityQuantity(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperC.<QuantitySchedule>of(filterQuantityByFinancialUnit.evaluate(MapperS.of(tradeState).<Trade>map("getTrade", _tradeState -> _tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("getValue", _f->_f.getValue()).getMulti(), MapperS.of(FinancialUnitEnum.SHARE).get()));
		}
		
		@Override
		protected Mapper<? extends InterestRatePayout> interestRatePayout(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperS.of(MapperS.of(tradeState).<Trade>map("getTrade", _tradeState -> _tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get());
		}
		
		@Override
		protected Mapper<? extends AssetPayout> assetPayout(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperS.of(MapperS.of(tradeState).<Trade>map("getTrade", _tradeState -> _tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Collateral>map("getCollateral", economicTerms -> economicTerms.getCollateral()).<ReferenceWithMetaCollateralPortfolio>mapC("getCollateralPortfolio", _collateral -> _collateral.getCollateralPortfolio()).<CollateralPortfolio>map("getValue", _f->_f.getValue()).<CollateralPosition>mapC("getCollateralPosition", collateralPortfolio -> collateralPortfolio.getCollateralPosition()).<Product>map("getProduct", position -> position.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<AssetPayout>mapC("getAssetPayout", payout -> payout.getAssetPayout()).get());
		}
		
		@Override
		protected Mapper<? extends Collateral> collateral(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperS.of(tradeState).<Trade>map("getTrade", _tradeState -> _tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Collateral>map("getCollateral", economicTerms -> economicTerms.getCollateral());
		}
		
		@Override
		protected Mapper<BigDecimal> haircutPercentage(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperMaths.<BigDecimal, BigDecimal, BigDecimal>subtract(MapperS.of(new BigDecimal("1.0")), MapperS.of(MapperS.of(collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).<CollateralProvisions>map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).<EligibleCollateralCriteria>mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get()).<CollateralTreatment>map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).<CollateralValuationTreatment>map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).<BigDecimal>map("getHaircutPercentage", collateralValuationTreatment -> collateralValuationTreatment.getHaircutPercentage()));
		}
		
		@Override
		protected Mapper<BigDecimal> valuationPercentage(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperMaths.<BigDecimal, Integer, BigDecimal>divide(MapperS.of(Integer.valueOf(1)), MapperS.of(haircutPercentage(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()));
		}
		
		@Override
		protected Mapper<BigDecimal> marginRatio(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperUtils.runSingle(() -> {
				if (exists(MapperS.of(MapperS.of(collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).<CollateralProvisions>map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).<EligibleCollateralCriteria>mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get()).<CollateralTreatment>map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).<CollateralValuationTreatment>map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).<BigDecimal>map("getHaircutPercentage", collateralValuationTreatment -> collateralValuationTreatment.getHaircutPercentage())).getOrDefault(false)) {
					return MapperS.of(valuationPercentage(tradeState, reset, recordStartDate, recordEndDate, transferDate).get());
				}
				else if (exists(MapperS.of(MapperS.of(collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).<CollateralProvisions>map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).<EligibleCollateralCriteria>mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get()).<CollateralTreatment>map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).<CollateralValuationTreatment>map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).<BigDecimal>map("getMarginPercentage", collateralValuationTreatment -> collateralValuationTreatment.getMarginPercentage())).getOrDefault(false)) {
					return MapperS.of(MapperS.of(collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).<CollateralProvisions>map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).<EligibleCollateralCriteria>mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get()).<CollateralTreatment>map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).<CollateralValuationTreatment>map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).<BigDecimal>map("getMarginPercentage", collateralValuationTreatment -> collateralValuationTreatment.getMarginPercentage());
				}
				else {
					return MapperS.of(new BigDecimal("1.0"));
				}
			});
		}
		
		@Override
		protected Mapper<BigDecimal> billingQuantity(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperMaths.<BigDecimal, BigDecimal, BigDecimal>multiply(MapperMaths.<BigDecimal, BigDecimal, BigDecimal>multiply(MapperS.of(reset).<Price>map("getResetValue", _reset -> _reset.getResetValue()).<BigDecimal>map("getValue", measureBase -> measureBase.getValue()), MapperC.<QuantitySchedule>of(securityQuantity(tradeState, reset, recordStartDate, recordEndDate, transferDate).getMulti()).<BigDecimal>map("getValue", measureBase -> measureBase.getValue())), MapperS.of(marginRatio(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()));
		}
		
		@Override
		protected Mapper<? extends CalculationPeriodData> calculationPeriodRange1(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperS.of(calculationPeriodRange0.evaluate(MapperS.of(recordStartDate).get(), MapperS.of(recordEndDate).get(), null));
		}
		
		@Override
		protected Mapper<BigDecimal> performance(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperUtils.runSingle(() -> {
				if (exists(MapperS.of(interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).getOrDefault(false)) {
					return MapperS.of(fixedAmount.evaluate(MapperS.of(interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).get(), MapperS.of(billingQuantity(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).get(), MapperS.of(recordEndDate).get(), MapperS.of(calculationPeriodRange1(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).get()));
				}
				else if (exists(MapperS.of(interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).getOrDefault(false)) {
					return MapperS.of(floatingAmount.evaluate(MapperS.of(interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).get(), MapperS.of(reset).<Price>map("getResetValue", _reset -> _reset.getResetValue()).<BigDecimal>map("getValue", measureBase -> measureBase.getValue()).get(), MapperS.of(billingQuantity(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).get(), MapperS.of(recordEndDate).get(), MapperS.of(calculationPeriodRange1(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).get()));
				}
				else {
					return MapperS.<BigDecimal>ofNull();
				}
			});
		}
		
		@Override
		protected Mapper<? extends Party> payerPartyReference(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperS.of(extractCounterpartyByRole.evaluate(MapperS.of(tradeState).<Trade>map("getTrade", _tradeState -> _tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Counterparty>mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), MapperS.of(interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).<PayerReceiver>map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer()).get())).<ReferenceWithMetaParty>map("getPartyReference", counterparty -> counterparty.getPartyReference()).<Party>map("getValue", _f->_f.getValue());
		}
		
		@Override
		protected Mapper<? extends Party> receiverPartyReference(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
			return MapperS.of(extractCounterpartyByRole.evaluate(MapperS.of(tradeState).<Trade>map("getTrade", _tradeState -> _tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Counterparty>mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), MapperS.of(interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()).<PayerReceiver>map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get())).<ReferenceWithMetaParty>map("getPartyReference", counterparty -> counterparty.getPartyReference()).<Party>map("getValue", _f->_f.getValue());
		}
	}
}
