package cdm.base.staticdata.party.validation;

import cdm.base.staticdata.party.Account;
import cdm.base.staticdata.party.metafields.FieldWithMetaAccountTypeEnum;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.metafields.FieldWithMetaString;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AccountValidator implements Validator<Account> {

	@Override
	public ValidationResult<Account> validate(RosettaPath path, Account o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("partyReference", (ReferenceWithMetaParty) o.getPartyReference() != null ? 1 : 0, 0, 1), 
				checkCardinality("accountNumber", (FieldWithMetaString) o.getAccountNumber() != null ? 1 : 0, 1, 1), 
				checkCardinality("accountName", (FieldWithMetaString) o.getAccountName() != null ? 1 : 0, 0, 1), 
				checkCardinality("accountType", (FieldWithMetaAccountTypeEnum) o.getAccountType() != null ? 1 : 0, 0, 1), 
				checkCardinality("accountBeneficiary", (ReferenceWithMetaParty) o.getAccountBeneficiary() != null ? 1 : 0, 0, 1), 
				checkCardinality("servicingParty", (ReferenceWithMetaParty) o.getServicingParty() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("Account", ValidationType.CARDINALITY, "Account", path, "", error);
		}
		return success("Account", ValidationType.CARDINALITY, "Account", path, "");
	}

}
