package cdm.base.math.validation;

import cdm.base.math.AveragingCalculationMethod;
import cdm.base.math.AveragingCalculationMethodEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AveragingCalculationMethodValidator implements Validator<AveragingCalculationMethod> {

	@Override
	public ValidationResult<AveragingCalculationMethod> validate(RosettaPath path, AveragingCalculationMethod o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("isWeighted", (Boolean) o.getIsWeighted() != null ? 1 : 0, 1, 1), 
				checkCardinality("calculationMethod", (AveragingCalculationMethodEnum) o.getCalculationMethod() != null ? 1 : 0, 1, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("AveragingCalculationMethod", ValidationType.CARDINALITY, "AveragingCalculationMethod", path, "", error);
		}
		return success("AveragingCalculationMethod", ValidationType.CARDINALITY, "AveragingCalculationMethod", path, "");
	}

}
