/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParserManager;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;

public class FoldManager {
    private RSyntaxTextArea textArea;
    private FoldParser parser;
    private List folds;
    private boolean codeFoldingEnabled;
    private PropertyChangeSupport support;
    public static final String PROPERTY_FOLDS_UPDATED = "FoldsUpdated";
    private Parser tempParser;

    public FoldManager(RSyntaxTextArea rSyntaxTextArea) {
        this.textArea = rSyntaxTextArea;
        this.support = new PropertyChangeSupport(this);
        Listener listener = new Listener();
        rSyntaxTextArea.getDocument().addDocumentListener(listener);
        rSyntaxTextArea.addPropertyChangeListener("RSTA.syntaxStyle", listener);
        this.folds = new ArrayList();
        this.updateFoldParser();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void clear() {
        this.folds.clear();
    }

    public boolean ensureOffsetNotInClosedFold(int n) {
        boolean bl = false;
        for (Fold fold = this.getDeepestFoldContaining(n); fold != null; fold = fold.getParent()) {
            if (!fold.isCollapsed()) continue;
            fold.setCollapsed(false);
            bl = true;
        }
        return bl;
    }

    public Fold getDeepestFoldContaining(int n) {
        Fold fold = null;
        if (n > -1) {
            for (int i = 0; i < this.folds.size(); ++i) {
                Fold fold2 = this.getFold(i);
                if (!fold2.containsOffset(n)) continue;
                fold = fold2.getDeepestFoldContaining(n);
                break;
            }
        }
        return fold;
    }

    public Fold getDeepestOpenFoldContaining(int n) {
        Fold fold = null;
        if (n > -1) {
            for (int i = 0; i < this.folds.size(); ++i) {
                Fold fold2 = this.getFold(i);
                if (!fold2.containsOffset(n)) continue;
                if (fold2.isCollapsed()) {
                    return null;
                }
                fold = fold2.getDeepestOpenFoldContaining(n);
                break;
            }
        }
        return fold;
    }

    public Fold getFold(int n) {
        return (Fold)this.folds.get(n);
    }

    public int getFoldCount() {
        return this.folds.size();
    }

    public Fold getFoldForLine(int n) {
        return this.getFoldForLineImpl(null, this.folds, n);
    }

    private Fold getFoldForLineImpl(Fold fold, List list, int n) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            Fold fold2 = (Fold)list.get(n4);
            int n5 = fold2.getStartLine();
            if (n == n5) {
                return fold2;
            }
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            int n6 = fold2.getEndLine();
            if (n >= n6) {
                n2 = n4 + 1;
                continue;
            }
            List list2 = fold2.getChildren();
            return list2 != null ? this.getFoldForLineImpl(fold2, list2, n) : null;
        }
        return null;
    }

    public int getHiddenLineCount() {
        int n = 0;
        for (int i = 0; i < this.folds.size(); ++i) {
            n += ((Fold)this.folds.get(i)).getCollapsedLineCount();
        }
        return n;
    }

    public int getHiddenLineCountAbove(int n) {
        return this.getHiddenLineCountAbove(n, false);
    }

    public int getHiddenLineCountAbove(int n, boolean bl) {
        int n2 = 0;
        for (int i = 0; i < this.folds.size(); ++i) {
            int n3;
            Fold fold = (Fold)this.folds.get(i);
            int n4 = n3 = bl ? n + n2 : n;
            if (fold.getStartLine() >= n3) break;
            n2 += this.getHiddenLineCountAboveImpl(fold, n3, bl);
        }
        return n2;
    }

    private int getHiddenLineCountAboveImpl(Fold fold, int n, boolean bl) {
        int n2 = 0;
        if (fold.getEndLine() < n || fold.isCollapsed() && fold.getStartLine() < n) {
            n2 = fold.getCollapsedLineCount();
        } else {
            int n3 = fold.getChildCount();
            for (int i = 0; i < n3; ++i) {
                int n4;
                Fold fold2 = fold.getChild(i);
                int n5 = n4 = bl ? n + n2 : n;
                if (fold2.getStartLine() >= n4) break;
                n2 += this.getHiddenLineCountAboveImpl(fold2, n4, bl);
            }
        }
        return n2;
    }

    public int getLastVisibleLine() {
        Fold fold;
        int n;
        int n2 = this.textArea.getLineCount() - 1;
        if (this.isCodeFoldingSupportedAndEnabled() && (n = this.getFoldCount()) > 0 && (fold = this.getFold(n - 1)).containsLine(n2)) {
            if (fold.isCollapsed()) {
                n2 = fold.getStartLine();
            } else {
                while (fold.getHasChildFolds() && (fold = fold.getLastChild()).containsLine(n2)) {
                    if (!fold.isCollapsed()) continue;
                    n2 = fold.getStartLine();
                    break;
                }
            }
        }
        return n2;
    }

    public int getVisibleLineAbove(int n) {
        if (n <= 0 || n >= this.textArea.getLineCount()) {
            return -1;
        }
        while (--n >= 0 && this.isLineHidden(n)) {
        }
        return n;
    }

    public int getVisibleLineBelow(int n) {
        int n2 = this.textArea.getLineCount();
        if (n < 0 || n >= n2 - 1) {
            return -1;
        }
        while (++n < n2 && this.isLineHidden(n)) {
        }
        return n == n2 ? -1 : n;
    }

    public boolean isCodeFoldingEnabled() {
        return this.codeFoldingEnabled;
    }

    public boolean isCodeFoldingSupportedAndEnabled() {
        return this.codeFoldingEnabled && this.parser != null;
    }

    public boolean isFoldStartLine(int n) {
        return this.getFoldForLine(n) != null;
    }

    public boolean isLineHidden(int n) {
        for (int i = 0; i < this.folds.size(); ++i) {
            Fold fold = (Fold)this.folds.get(i);
            if (!fold.containsLine(n)) continue;
            if (fold.isCollapsed()) {
                return true;
            }
            return this.isLineHiddenImpl(fold, n);
        }
        return false;
    }

    private boolean isLineHiddenImpl(Fold fold, int n) {
        for (int i = 0; i < fold.getChildCount(); ++i) {
            Fold fold2 = fold.getChild(i);
            if (!fold2.containsLine(n)) continue;
            if (fold2.isCollapsed()) {
                return true;
            }
            return this.isLineHiddenImpl(fold2, n);
        }
        return false;
    }

    private void keepFoldState(Fold fold, List list) {
        int n = Collections.binarySearch(list, fold);
        if (n >= 0) {
            Fold fold2 = (Fold)list.get(n);
            fold.setCollapsed(fold2.isCollapsed());
        } else {
            List list2;
            Fold fold3;
            int n2 = -(n + 1);
            if (n2 > 0 && (fold3 = (Fold)list.get(n2 - 1)).containsOffset(fold.getStartOffset()) && (list2 = fold3.getChildren()) != null) {
                this.keepFoldState(fold, list2);
            }
        }
    }

    private void keepFoldStates(List list, List list2) {
        for (int i = 0; i < list.size(); ++i) {
            Fold fold = (Fold)list.get(i);
            this.keepFoldState(fold, this.folds);
            List list3 = fold.getChildren();
            if (list3 == null) continue;
            this.keepFoldStates(list3, list2);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void reparse() {
        if (this.codeFoldingEnabled && this.parser != null) {
            List list = this.parser.getFolds(this.textArea);
            if (list == null) {
                list = Collections.EMPTY_LIST;
            } else {
                this.keepFoldStates(list, this.folds);
            }
            this.folds = list;
            this.support.firePropertyChange(PROPERTY_FOLDS_UPDATED, null, this.folds);
            this.textArea.repaint();
        } else {
            this.folds.clear();
        }
    }

    public void setCodeFoldingEnabled(boolean bl) {
        if (bl != this.codeFoldingEnabled) {
            this.codeFoldingEnabled = bl;
            if (this.tempParser != null) {
                this.textArea.removeParser(this.tempParser);
            }
            if (bl) {
                this.tempParser = new AbstractParser(){

                    public ParseResult parse(RSyntaxDocument rSyntaxDocument, String string) {
                        FoldManager.this.reparse();
                        return new DefaultParseResult(this);
                    }
                };
                this.textArea.addParser(this.tempParser);
                this.support.firePropertyChange(PROPERTY_FOLDS_UPDATED, null, null);
            } else {
                this.folds = Collections.EMPTY_LIST;
                this.textArea.repaint();
                this.support.firePropertyChange(PROPERTY_FOLDS_UPDATED, null, null);
            }
        }
    }

    public void setFolds(List list) {
        this.folds = list;
    }

    private void updateFoldParser() {
        this.parser = FoldParserManager.get().getFoldParser(this.textArea.getSyntaxEditingStyle());
    }

    private class Listener
    implements DocumentListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Fold fold;
            int n;
            int n2 = documentEvent.getOffset();
            int n3 = n2 + documentEvent.getLength();
            Document document = documentEvent.getDocument();
            Element element = document.getDefaultRootElement();
            int n4 = element.getElementIndex(n2);
            if (n4 != (n = element.getElementIndex(n3)) && (fold = FoldManager.this.getFoldForLine(n4)) != null && fold.isCollapsed()) {
                fold.toggleCollapsedState();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FoldManager.this.updateFoldParser();
            FoldManager.this.reparse();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            int n = documentEvent.getOffset();
            try {
                int n2 = FoldManager.this.textArea.getLineOfOffset(n);
                Fold fold = FoldManager.this.getFoldForLine(n2);
                if (fold != null && fold.isCollapsed()) {
                    fold.toggleCollapsedState();
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }
}

