/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.Table;

class CsvTableReader {
    private static final String NULL_VALUE = "\\N";

    private CsvTableReader() {
    }

    static void readCsv(StringReader stringReader, Table<?> table, IRuntimeRepository productRepository) {
        CSVParser csvParser = new CSVParserBuilder().withSeparator('|').withQuoteChar('\"').withEscapeChar('\\').build();
        try (CSVReader csvReader = new CSVReaderBuilder((Reader)stringReader).withCSVParser((ICSVParser)csvParser).build();){
            String[] csvLine;
            while ((csvLine = csvReader.readNext()) != null) {
                for (int i = 0; i < csvLine.length; ++i) {
                    if (!NULL_VALUE.equals(csvLine[i])) continue;
                    csvLine[i] = null;
                }
                table.addRow(Arrays.asList(csvLine), productRepository);
            }
        }
        catch (CsvValidationException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

