/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.Month;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsMonth<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final Month expectedMonth;
    private final TemporalAdapter<T> accessor;

    public IsMonth(Month month, TemporalAdapter<T> accessor) {
        this.expectedMonth = month;
        this.accessor = accessor;
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        Month actualMonth = Month.of(this.accessor.asTemporal(actual).get(ChronoField.MONTH_OF_YEAR));
        if (this.expectedMonth.equals(actualMonth)) {
            return true;
        }
        mismatchDescription.appendText("the date is in " + this.describeMonth(actualMonth));
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("the date is in the month of " + this.describeMonth(this.expectedMonth));
    }

    private String describeMonth(Month m) {
        return m.getDisplayName(TextStyle.FULL, Locale.getDefault());
    }
}

