/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Locale;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsMinimum<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final TemporalField datePart;
    private final String datePartName;
    private final TemporalAdapter<T> adapter;

    public IsMinimum(TemporalField datePart, TemporalAdapter<T> adapter) {
        this.datePart = datePart;
        this.datePartName = datePart.getDisplayName(Locale.getDefault());
        this.adapter = adapter;
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        long actualValue = this.datePart.getFrom(this.adapter.asTemporal(actual));
        ValueRange range = this.datePart.rangeRefinedBy(this.adapter.asTemporal(actual));
        if (range.getMinimum() == actualValue) {
            return true;
        }
        mismatchDesc.appendText("value is " + actualValue + " instead of " + range.getMaximum());
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("the minimum value of " + this.datePartName);
    }
}

