/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import org.exparity.hamcrest.date.core.TemporalFormatter;
import org.exparity.hamcrest.date.core.TemporalWrapper;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsAfter<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final TemporalWrapper<T> expected;
    private final TemporalFormatter<T> describer;

    public IsAfter(TemporalWrapper<T> expected, TemporalFormatter<T> describer) {
        this.expected = expected;
        this.describer = describer;
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        if (this.expected.isSame(actual) || this.expected.isAfter(actual)) {
            mismatchDescription.appendText("date is " + this.describer.describe(this.expected.unwrap()));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is after " + this.describer.describe(this.expected.unwrap()));
    }
}

