/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.filter;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eurekaclinical.standardapis.dao.UserDao;
import org.eurekaclinical.standardapis.entity.RoleEntity;
import org.eurekaclinical.standardapis.entity.UserEntity;
import org.eurekaclinical.standardapis.filter.RolesRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RolesFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RolesFilter.class);
    private final UserDao<? extends UserEntity<? extends RoleEntity>> userDao;

    @Inject
    public RolesFilter(UserDao<? extends UserEntity<? extends RoleEntity>> inUserDao) {
        this.userDao = inUserDao;
    }

    public void init(FilterConfig fc) throws ServletException {
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        Principal principal = servletRequest.getUserPrincipal();
        if (principal != null) {
            UserEntity<? extends RoleEntity> user = this.userDao.getByPrincipal(principal);
            List<? extends RoleEntity> roleEntities = user.getRoles();
            HashSet<String> roles = new HashSet<String>();
            for (RoleEntity roleEntity : roleEntities) {
                roles.add(roleEntity.getName());
            }
            RolesRequestWrapper wrappedRequest = new RolesRequestWrapper(servletRequest, principal, roles);
            inChain.doFilter((ServletRequest)wrappedRequest, inResponse);
        } else {
            inChain.doFilter(inRequest, inResponse);
        }
    }

    public void destroy() {
    }
}

