/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.dao;

import java.util.List;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import org.eurekaclinical.standardapis.dao.Dao;
import org.eurekaclinical.standardapis.dao.DatabaseSupport;

public class GenericDao<T, PK>
implements Dao<T, PK> {
    private final Class<T> entityClass;
    private final Provider<EntityManager> managerProvider;

    protected GenericDao(Class<T> inEntityClass, Provider<EntityManager> inManagerProvider) {
        this.entityClass = inEntityClass;
        this.managerProvider = inManagerProvider;
    }

    @Override
    public T create(T entity) {
        EntityManager entityManager = this.getEntityManager();
        entityManager.persist(entity);
        return entity;
    }

    @Override
    public T retrieve(PK uniqueId) {
        return (T)this.getEntityManager().find(this.entityClass, uniqueId);
    }

    @Override
    public T update(T entity) {
        EntityManager entityManager = this.getEntityManager();
        Object result = entityManager.merge(entity);
        return (T)result;
    }

    @Override
    public T remove(T entity) {
        EntityManager entityManager = this.getEntityManager();
        if (entityManager.contains(entity)) {
            entityManager.remove(entity);
        } else {
            entityManager.remove(entityManager.merge(entity));
        }
        return entity;
    }

    @Override
    public T refresh(T entity) {
        this.getEntityManager().refresh(entity);
        return entity;
    }

    @Override
    public List<T> getAll() {
        DatabaseSupport dbSupport = new DatabaseSupport(this.getEntityManager());
        return dbSupport.getAll(this.entityClass);
    }

    protected List<T> getListAsc(SingularAttribute<T, ?> attribute) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(this.entityClass);
        Root root = criteriaQuery.from(this.entityClass);
        criteriaQuery.orderBy(new Order[]{builder.asc((Expression)root.get(attribute))});
        return entityManager.createQuery(criteriaQuery).getResultList();
    }

    protected <Y> T getUniqueByAttribute(SingularAttribute<T, Y> attribute, Y value) {
        try {
            return new DatabaseSupport(this.getEntityManager()).getUniqueByAttribute(this.entityClass, attribute, value);
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    protected <Y> List<T> getListByAttribute(SingularAttribute<T, Y> attribute, Y value) {
        return new DatabaseSupport(this.getEntityManager()).getListByAttribute(this.entityClass, attribute, value);
    }

    protected <Y extends Number> List<T> getListByAttribute(SingularAttribute<T, Y> attribute, SqlComparator comparator, Y value) {
        TypedQuery<T> query = this.createTypedQuery(attribute, comparator, value);
        return query.getResultList();
    }

    private <Y extends Number> TypedQuery<T> createTypedQuery(SingularAttribute<T, Y> attribute, SqlComparator comparator, Y value) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(this.entityClass);
        Root root = criteriaQuery.from(this.entityClass);
        Path path = root.get(attribute);
        switch (comparator) {
            case LESS_THAN: {
                Predicate pred = builder.lt((Expression)path, value);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                Predicate pred = builder.le((Expression)path, value);
                break;
            }
            case EQUAL_TO: {
                Predicate pred = builder.equal((Expression)path, value);
                break;
            }
            case NOT_EQUAL_TO: {
                Predicate pred = builder.notEqual((Expression)path, value);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                Predicate pred = builder.ge((Expression)path, value);
                break;
            }
            case GREATER_THAN: {
                Predicate pred = builder.gt((Expression)path, value);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid SQLComparator: " + (Object)((Object)comparator)));
            }
        }
        return entityManager.createQuery(criteriaQuery.where((Expression)builder.equal((Expression)path, value)));
    }

    protected <Y> List<T> getListByAttribute(QueryPathProvider<T, Y> provider, Y value) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(this.entityClass);
        Root root = criteriaQuery.from(this.entityClass);
        Path<Y> path = provider.getPath(root, builder);
        TypedQuery typedQuery = entityManager.createQuery(criteriaQuery.where((Expression)builder.equal(path, value)));
        return typedQuery.getResultList();
    }

    protected final EntityManager getEntityManager() {
        return (EntityManager)this.managerProvider.get();
    }

    protected static interface QueryPathProvider<E, P> {
        public Path<P> getPath(Root<E> var1, CriteriaBuilder var2);
    }

    public static enum SqlComparator {
        LESS_THAN_OR_EQUAL_TO,
        LESS_THAN,
        EQUAL_TO,
        NOT_EQUAL_TO,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL_TO;

    }
}

