/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.config;

import java.util.HashMap;
import java.util.Map;
import org.eurekaclinical.standardapis.props.EurekaClinicalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServletModuleSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletModuleSupport.class);
    private static final String CAS_CALLBACK_PATH = "/proxyCallback";
    private final EurekaClinicalProperties properties;
    private final String contextPath;

    public ServletModuleSupport(String contextPath, EurekaClinicalProperties inProperties) {
        this.properties = inProperties;
        this.contextPath = contextPath;
    }

    public Map<String, String> getCasProxyFilterInitParamsForWebApp() {
        Map<String, String> params = this.getCasProxyFilterInitParams();
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        return params;
    }

    public Map<String, String> getCasProxyFilterInitParamsForWebService() {
        Map<String, String> params = this.getCasProxyFilterInitParams();
        params.put("redirectAfterValidation", "false");
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        return params;
    }

    public Map<String, String> getCasAuthenticationFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("casServerLoginUrl", this.getCasLoginUrl());
        params.put("serverName", this.properties.getProxyCallbackServer());
        params.put("renew", "false");
        params.put("gateway", "false");
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        return params;
    }

    public Map<String, String> getServletRequestWrapperFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("roleAttribute", "authorities");
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        return params;
    }

    protected void printParams(Map<String, String> inParams) {
        for (Map.Entry<String, String> entry : inParams.entrySet()) {
            LOGGER.debug(entry.getKey() + " -> " + entry.getValue());
        }
    }

    protected String getCasLoginUrl() {
        return this.properties.getCasLoginUrl();
    }

    private String getProxyCallbackUrl() {
        return this.properties.getProxyCallbackServer() + this.contextPath + CAS_CALLBACK_PATH;
    }

    private String getProxyReceptorUrl() {
        return CAS_CALLBACK_PATH;
    }

    private Map<String, String> getCasProxyFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acceptAnyProxy", "true");
        params.put("proxyCallbackUrl", this.getProxyCallbackUrl());
        params.put("proxyReceptorUrl", this.getProxyReceptorUrl());
        params.put("casServerUrlPrefix", this.properties.getCasUrl());
        params.put("serverName", this.properties.getProxyCallbackServer());
        return params;
    }
}

