/*
 * Decompiled with CFR 0.152.
 */
package org.etby.datacache;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.etby.datacache.CacheHelper;
import org.etby.datacache.Cacheable;

public abstract class AbstractCacheHelper<T extends Cacheable>
implements CacheHelper {
    protected T data;
    private HashSet<Integer> mCFs = new HashSet();

    public AbstractCacheHelper(T data) {
        this.data = data;
    }

    @Override
    public boolean isAvailableField(int cf) {
        int[] cfs = this.getAvailableCaches();
        if (cfs != null && cfs.length != 0) {
            Arrays.sort(cfs);
            if (Arrays.binarySearch(cfs, cf) > -1) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void notifyCacheChanged(int cf) {
        this.mCFs.add(cf);
    }

    @Override
    public int[] getChangedCaches() {
        int[] result = new int[this.mCFs.size()];
        int i = 0;
        Iterator<Integer> iterator = this.mCFs.iterator();
        while (iterator.hasNext()) {
            result[i] = iterator.next();
            ++i;
        }
        return result;
    }

    @Override
    public void resetCache() {
        this.mCFs.clear();
    }

    @Override
    public void updateTo(int[] cfs, Cacheable target) {
        if (cfs == null || cfs.length == 0) {
            return;
        }
        CacheHelper helper = target.getHelper();
        if (helper == null) {
            return;
        }
        for (int cf : cfs) {
            helper.updateField(cf, this.getField(cf));
        }
    }

    @Override
    public void updateTo(Cacheable target) {
        this.updateTo(this.getChangedCaches(), target);
    }
}

