/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support.init.proxy;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.common.init.proxy.ClientProxy;
import org.elasticsearch.xpack.security.InternalClient;

public class WatcherClientProxy
extends ClientProxy {
    private final TimeValue defaultSearchTimeout;
    private final TimeValue defaultIndexTimeout;
    private final TimeValue defaultBulkTimeout;

    public WatcherClientProxy(Settings settings, InternalClient client) {
        super(client);
        this.defaultSearchTimeout = settings.getAsTime("xpack.watcher.internal.ops.search.default_timeout", TimeValue.timeValueSeconds((long)30L));
        this.defaultIndexTimeout = settings.getAsTime("xpack.watcher.internal.ops.index.default_timeout", TimeValue.timeValueSeconds((long)60L));
        this.defaultBulkTimeout = settings.getAsTime("xpack.watcher.internal.ops.bulk.default_timeout", TimeValue.timeValueSeconds((long)120L));
    }

    public static WatcherClientProxy of(Client client) {
        return new WatcherClientProxy(Settings.EMPTY, client instanceof InternalClient ? (InternalClient)client : new InternalClient(client.settings(), client.threadPool(), client, null));
    }

    public IndexResponse index(IndexRequest request, TimeValue timeout) {
        if (timeout == null) {
            timeout = this.defaultIndexTimeout;
        }
        return (IndexResponse)this.client.index(this.preProcess(request)).actionGet(timeout);
    }

    public UpdateResponse update(UpdateRequest request) {
        return (UpdateResponse)this.client.update(this.preProcess(request)).actionGet(this.defaultIndexTimeout);
    }

    public BulkResponse bulk(BulkRequest request, TimeValue timeout) {
        if (timeout == null) {
            timeout = this.defaultBulkTimeout;
        }
        return (BulkResponse)this.client.bulk(this.preProcess(request)).actionGet(timeout);
    }

    public void index(IndexRequest request, ActionListener<IndexResponse> listener) {
        this.client.index(this.preProcess(request), listener);
    }

    @Override
    public void bulk(BulkRequest request, ActionListener<BulkResponse> listener) {
        this.client.bulk(this.preProcess(request), listener);
    }

    public DeleteResponse delete(DeleteRequest request) {
        return (DeleteResponse)this.client.delete(this.preProcess(request)).actionGet(this.defaultIndexTimeout);
    }

    public SearchResponse search(SearchRequest request, TimeValue timeout) {
        if (timeout == null) {
            timeout = this.defaultSearchTimeout;
        }
        return (SearchResponse)this.client.search(this.preProcess(request)).actionGet(timeout);
    }

    public SearchResponse searchScroll(String scrollId, TimeValue timeout) {
        SearchScrollRequest request = new SearchScrollRequest(scrollId).scroll(timeout);
        return (SearchResponse)this.client.searchScroll(this.preProcess(request)).actionGet(this.defaultSearchTimeout);
    }

    public ClearScrollResponse clearScroll(String scrollId) {
        ClearScrollRequest request = new ClearScrollRequest();
        request.addScrollId(scrollId);
        return (ClearScrollResponse)this.client.clearScroll(this.preProcess(request)).actionGet(this.defaultSearchTimeout);
    }

    public RefreshResponse refresh(RefreshRequest request) {
        return (RefreshResponse)this.client.admin().indices().refresh(this.preProcess(request)).actionGet(this.defaultSearchTimeout);
    }

    public void putTemplate(PutIndexTemplateRequest request, ActionListener<PutIndexTemplateResponse> listener) {
        this.client.admin().indices().putTemplate(this.preProcess(request), listener);
    }
}

