/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.script.Script;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.xpack.upgrade.InternalIndexReindexer;
import org.elasticsearch.xpack.upgrade.UpgradeActionRequired;

public class IndexUpgradeCheck<T>
extends AbstractComponent {
    public static final int UPRADE_VERSION = 6;
    private final String name;
    private final Function<IndexMetaData, UpgradeActionRequired> actionRequired;
    private final InternalIndexReindexer<T> reindexer;

    public IndexUpgradeCheck(String name, Settings settings, Function<IndexMetaData, UpgradeActionRequired> actionRequired, Client client, ClusterService clusterService, String[] types, Script updateScript) {
        this(name, settings, actionRequired, client, clusterService, types, updateScript, listener -> listener.onResponse(null), (t, listener) -> listener.onResponse((Object)TransportResponse.Empty.INSTANCE));
    }

    public IndexUpgradeCheck(String name, Settings settings, Function<IndexMetaData, UpgradeActionRequired> actionRequired, Client client, ClusterService clusterService, String[] types, Script updateScript, Consumer<ActionListener<T>> preUpgrade, BiConsumer<T, ActionListener<TransportResponse.Empty>> postUpgrade) {
        super(settings);
        this.name = name;
        this.actionRequired = actionRequired;
        this.reindexer = new InternalIndexReindexer<T>(client, clusterService, 6, updateScript, types, preUpgrade, postUpgrade);
    }

    public String getName() {
        return this.name;
    }

    public UpgradeActionRequired actionRequired(IndexMetaData indexMetaData) {
        return this.actionRequired.apply(indexMetaData);
    }

    public void upgrade(TaskId task, IndexMetaData indexMetaData, ClusterState state, ActionListener<BulkByScrollResponse> listener) {
        this.reindexer.upgrade(task, indexMetaData.getIndex().getName(), state, listener);
    }
}

