/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ssl.CertUtils;
import org.elasticsearch.xpack.ssl.KeyConfig;

class StoreKeyConfig
extends KeyConfig {
    final String keyStorePath;
    final SecureString keyStorePassword;
    final String keyStoreAlgorithm;
    final SecureString keyPassword;
    final String trustStoreAlgorithm;

    StoreKeyConfig(String keyStorePath, SecureString keyStorePassword, SecureString keyPassword, String keyStoreAlgorithm, String trustStoreAlgorithm) {
        this.keyStorePath = Objects.requireNonNull(keyStorePath, "keystore path must be specified");
        this.keyStorePassword = Objects.requireNonNull(keyStorePassword, "keystore password must be specified").clone();
        this.keyPassword = Objects.requireNonNull(keyPassword).clone();
        this.keyStoreAlgorithm = keyStoreAlgorithm;
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    X509ExtendedKeyManager createKeyManager(@Nullable Environment environment) {
        try (InputStream in = Files.newInputStream(CertUtils.resolvePath(this.keyStorePath, environment), new OpenOption[0]);){
            KeyStore ks = KeyStore.getInstance("jks");
            assert (this.keyStorePassword != null);
            ks.load(in, this.keyStorePassword.getChars());
            X509ExtendedKeyManager x509ExtendedKeyManager = CertUtils.keyManager(ks, this.keyPassword.getChars(), this.keyStoreAlgorithm);
            return x509ExtendedKeyManager;
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a KeyManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            return CertUtils.trustManager(this.keyStorePath, this.keyStorePassword.getChars(), this.trustStoreAlgorithm, environment);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        return Collections.singletonList(CertUtils.resolvePath(this.keyStorePath, environment));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreKeyConfig that = (StoreKeyConfig)o;
        if (this.keyStorePath != null ? !this.keyStorePath.equals(that.keyStorePath) : that.keyStorePath != null) {
            return false;
        }
        if (this.keyStorePassword != null ? !this.keyStorePassword.equals((Object)that.keyStorePassword) : that.keyStorePassword != null) {
            return false;
        }
        if (this.keyStoreAlgorithm != null ? !this.keyStoreAlgorithm.equals(that.keyStoreAlgorithm) : that.keyStoreAlgorithm != null) {
            return false;
        }
        if (this.keyPassword != null ? !this.keyPassword.equals((Object)that.keyPassword) : that.keyPassword != null) {
            return false;
        }
        return this.trustStoreAlgorithm != null ? this.trustStoreAlgorithm.equals(that.trustStoreAlgorithm) : that.trustStoreAlgorithm == null;
    }

    @Override
    public int hashCode() {
        int result = this.keyStorePath != null ? this.keyStorePath.hashCode() : 0;
        result = 31 * result + (this.keyStorePassword != null ? this.keyStorePassword.hashCode() : 0);
        result = 31 * result + (this.keyStoreAlgorithm != null ? this.keyStoreAlgorithm.hashCode() : 0);
        result = 31 * result + (this.keyPassword != null ? this.keyPassword.hashCode() : 0);
        result = 31 * result + (this.trustStoreAlgorithm != null ? this.trustStoreAlgorithm.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "keyStorePath=[" + this.keyStorePath + "], keyStoreAlgorithm=[" + this.keyStoreAlgorithm + "], trustStoreAlgorithm=[" + this.trustStoreAlgorithm + "]";
    }
}

