/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.ssl.SSLClientAuth;
import org.elasticsearch.xpack.ssl.VerificationMode;

public class SSLConfigurationSettings {
    public final Setting<List<String>> ciphers;
    public final Setting<List<String>> supportedProtocols;
    public final Setting<Optional<String>> keystorePath;
    public final Setting<SecureString> keystorePassword;
    public final Setting<String> keystoreAlgorithm;
    public final Setting<SecureString> keystoreKeyPassword;
    public final Setting<Optional<String>> truststorePath;
    public final Setting<SecureString> truststorePassword;
    public final Setting<String> truststoreAlgorithm;
    public final Setting<Optional<String>> keyPath;
    public final Setting<SecureString> keyPassword;
    public final Setting<Optional<String>> cert;
    public final Setting<List<String>> caPaths;
    public final Setting<Optional<SSLClientAuth>> clientAuth;
    public final Setting<Optional<VerificationMode>> verificationMode;
    public final Setting<SecureString> legacyTruststorePassword;
    final Setting<SecureString> legacyKeystorePassword;
    final Setting<SecureString> legacyKeystoreKeyPassword;
    final Setting<SecureString> legacyKeyPassword;
    private final List<Setting<?>> allSettings;

    private SSLConfigurationSettings(String prefix) {
        assert (prefix != null) : "Prefix cannot be null (but can be blank)";
        this.ciphers = Setting.listSetting((String)(prefix + "cipher_suites"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        this.supportedProtocols = Setting.listSetting((String)(prefix + "supported_protocols"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        this.keystorePath = new Setting(prefix + "keystore.path", s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        this.legacyKeystorePassword = new Setting(prefix + "keystore.password", "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
        this.keystorePassword = SecureSetting.secureString((String)(prefix + "keystore.secure_password"), this.legacyKeystorePassword, (Setting.Property[])new Setting.Property[0]);
        this.legacyKeystoreKeyPassword = new Setting(prefix + "keystore.key_password", "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
        this.keystoreKeyPassword = SecureSetting.secureString((String)(prefix + "keystore.secure_key_password"), this.legacyKeystoreKeyPassword, (Setting.Property[])new Setting.Property[0]);
        this.truststorePath = new Setting(prefix + "truststore.path", s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        this.legacyTruststorePassword = new Setting(prefix + "truststore.password", "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
        this.truststorePassword = SecureSetting.secureString((String)(prefix + "truststore.secure_password"), this.legacyTruststorePassword, (Setting.Property[])new Setting.Property[0]);
        this.keystoreAlgorithm = new Setting(prefix + "keystore.algorithm", s -> KeyManagerFactory.getDefaultAlgorithm(), Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        this.truststoreAlgorithm = new Setting(prefix + "truststore.algorithm", s -> TrustManagerFactory.getDefaultAlgorithm(), Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        this.keyPath = new Setting(prefix + "key", s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        this.legacyKeyPassword = new Setting(prefix + "key_passphrase", "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
        this.keyPassword = SecureSetting.secureString((String)(prefix + "secure_key_passphrase"), this.legacyKeyPassword, (Setting.Property[])new Setting.Property[0]);
        this.cert = new Setting(prefix + "certificate", s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        this.caPaths = Setting.listSetting((String)(prefix + "certificate_authorities"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        this.clientAuth = new Setting(prefix + "client_authentication", (String)null, s -> s == null ? Optional.empty() : Optional.of(SSLClientAuth.parse(s)), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        this.verificationMode = new Setting(prefix + "verification_mode", (String)null, s -> s == null ? Optional.empty() : Optional.of(VerificationMode.parse(s)), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        this.allSettings = Arrays.asList(this.ciphers, this.supportedProtocols, this.keystorePath, this.keystorePassword, this.keystoreAlgorithm, this.keystoreKeyPassword, this.truststorePath, this.truststorePassword, this.truststoreAlgorithm, this.keyPath, this.keyPassword, this.cert, this.caPaths, this.clientAuth, this.verificationMode, this.legacyKeystorePassword, this.legacyKeystoreKeyPassword, this.legacyKeyPassword, this.legacyTruststorePassword);
    }

    public List<Setting<?>> getAllSettings() {
        return this.allSettings;
    }

    public static SSLConfigurationSettings withoutPrefix() {
        return new SSLConfigurationSettings("");
    }

    public static SSLConfigurationSettings withPrefix(String prefix) {
        assert (prefix.endsWith("ssl.")) : "The ssl config prefix (" + prefix + ") should end in 'ssl.'";
        return new SSLConfigurationSettings(prefix);
    }
}

