/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.transport.SSLExceptionHelper;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty4.IpFilterRemoteAddressFilter;
import org.elasticsearch.xpack.ssl.SSLConfiguration;
import org.elasticsearch.xpack.ssl.SSLService;

public class SecurityNetty4Transport
extends Netty4Transport {
    private static final Setting<Boolean> PROFILE_SSL_SETTING = Setting.boolSetting((String)Security.setting("ssl.enabled"), (boolean)false, (Setting.Property[])new Setting.Property[0]);
    private final SSLService sslService;
    @Nullable
    private final IPFilter authenticator;
    private final boolean defaultTransportSslEnabled;
    private final SSLConfiguration sslConfiguration;
    private final Map<String, SSLConfiguration> profileConfiguration;

    public SecurityNetty4Transport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, @Nullable IPFilter authenticator, SSLService sslService) {
        super(settings, threadPool, networkService, bigArrays, namedWriteableRegistry, circuitBreakerService);
        this.authenticator = authenticator;
        this.defaultTransportSslEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        this.sslService = sslService;
        Settings transportSSLSettings = settings.getByPrefix(Security.setting("transport.ssl."));
        this.sslConfiguration = this.defaultTransportSslEnabled ? sslService.sslConfiguration(transportSSLSettings, Settings.EMPTY) : null;
        Map profileSettingsMap = settings.getGroups("transport.profiles.", true);
        HashMap<String, SSLConfiguration> profileConfiguration = new HashMap<String, SSLConfiguration>(profileSettingsMap.size() + 1);
        if (this.sslConfiguration != null) {
            this.validateProfileSettings(sslService, transportSSLSettings, "default", transportSSLSettings);
            profileConfiguration.put("default", this.sslConfiguration);
        } else {
            profileConfiguration.put("default", null);
        }
        for (Map.Entry entry : profileSettingsMap.entrySet()) {
            Settings profileSettings = (Settings)entry.getValue();
            String name = (String)entry.getKey();
            if (SecurityNetty4Transport.isProfileSSLEnabled(profileSettings, this.defaultTransportSslEnabled)) {
                Settings profileSslSettings = profileSettings.getByPrefix(Security.setting("ssl."));
                SSLConfiguration configuration = sslService.sslConfiguration(profileSslSettings, transportSSLSettings);
                profileConfiguration.put(name, configuration);
                this.validateProfileSettings(sslService, transportSSLSettings, name, profileSslSettings);
                continue;
            }
            profileConfiguration.put(name, null);
        }
        this.profileConfiguration = Collections.unmodifiableMap(profileConfiguration);
    }

    void validateProfileSettings(SSLService sslService, Settings transportSSLSettings, String name, Settings profileSslSettings) {
        if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue() && !sslService.isConfigurationValidForServerUsage(profileSslSettings, transportSSLSettings)) {
            if ("default".equals(name)) {
                throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [xpack.security.transport.ssl.key] or [xpack.security.transport.ssl.keystore.path] setting");
            }
            throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [transport.profiles." + name + ".xpack.security.ssl.key] or [transport.profiles." + name + ".xpack.security.ssl.keystore.path] setting");
        }
    }

    public static boolean isProfileSSLEnabled(Settings profileSettings, boolean defaultTransportSSL) {
        return PROFILE_SSL_SETTING.exists(profileSettings) ? (Boolean)PROFILE_SSL_SETTING.get(profileSettings) : defaultTransportSSL;
    }

    protected void doStart() {
        super.doStart();
        if (this.authenticator != null) {
            this.authenticator.setBoundTransportAddress(this.boundAddress(), this.profileBoundAddresses());
        }
    }

    protected ChannelHandler getServerChannelInitializer(String name, Settings settings) {
        if (!this.profileConfiguration.containsKey(name)) {
            throw new IllegalStateException("unknown profile: " + name);
        }
        SSLConfiguration configuration = this.profileConfiguration.get(name);
        return new SecurityServerChannelInitializer(settings, name, configuration);
    }

    protected ChannelHandler getClientChannelInitializer() {
        return new SecurityClientChannelInitializer();
    }

    protected void onException(Channel channel, Exception e) throws IOException {
        if (!this.lifecycle.started()) {
            this.closeChannelWhileHandlingExceptions(channel);
        } else if (SSLExceptionHelper.isNotSslRecordException(e)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Message)new ParameterizedMessage("received plaintext traffic on an encrypted channel, closing connection {}", (Object)channel), (Throwable)e);
            } else {
                this.logger.warn("received plaintext traffic on an encrypted channel, closing connection {}", (Object)channel);
            }
            this.closeChannelWhileHandlingExceptions(channel);
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException(e)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Message)new ParameterizedMessage("connection {} closed during ssl handshake", (Object)channel), (Throwable)e);
            } else {
                this.logger.warn("connection {} closed during handshake", (Object)channel);
            }
            this.closeChannelWhileHandlingExceptions(channel);
        } else if (SSLExceptionHelper.isReceivedCertificateUnknownException(e)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Message)new ParameterizedMessage("client did not trust server's certificate, closing connection {}", (Object)channel), (Throwable)e);
            } else {
                this.logger.warn("client did not trust this server's certificate, closing connection {}", (Object)channel);
            }
            this.closeChannelWhileHandlingExceptions(channel);
        } else {
            super.onException((Object)channel, e);
        }
    }

    private static class ClientSslHandlerInitializer
    extends ChannelOutboundHandlerAdapter {
        private final boolean hostnameVerificationEnabled;
        private final SSLConfiguration sslConfiguration;
        private final SSLService sslService;

        private ClientSslHandlerInitializer(SSLConfiguration sslConfiguration, SSLService sslService, boolean hostnameVerificationEnabled) {
            this.sslConfiguration = sslConfiguration;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.sslService = sslService;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            SSLEngine sslEngine;
            if (this.hostnameVerificationEnabled) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                sslEngine = this.sslService.createSSLEngine(this.sslConfiguration, inetSocketAddress.getHostString(), inetSocketAddress.getPort());
            } else {
                sslEngine = this.sslService.createSSLEngine(this.sslConfiguration, null, -1);
            }
            sslEngine.setUseClientMode(true);
            ctx.pipeline().replace((ChannelHandler)this, "ssl", (ChannelHandler)new SslHandler(sslEngine));
            super.connect(ctx, remoteAddress, localAddress, promise);
        }
    }

    private class SecurityClientChannelInitializer
    extends Netty4Transport.ClientChannelInitializer {
        private SecurityClientChannelInitializer() {
            super((Netty4Transport)SecurityNetty4Transport.this);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (SecurityNetty4Transport.this.sslConfiguration != null) {
                boolean hostnameVerificationEnabled = SecurityNetty4Transport.this.sslConfiguration.verificationMode().isHostnameVerificationEnabled();
                ch.pipeline().addFirst(new ChannelHandler[]{new ClientSslHandlerInitializer(SecurityNetty4Transport.this.sslConfiguration, SecurityNetty4Transport.this.sslService, hostnameVerificationEnabled)});
            }
        }
    }

    class SecurityServerChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        private final SSLConfiguration configuration;

        SecurityServerChannelInitializer(Settings settings, String name, SSLConfiguration configuration) {
            super((Netty4Transport)SecurityNetty4Transport.this, name, settings);
            this.configuration = configuration;
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (this.configuration != null) {
                SSLEngine serverEngine = SecurityNetty4Transport.this.sslService.createSSLEngine(this.configuration, null, -1);
                serverEngine.setUseClientMode(false);
                ch.pipeline().addFirst(new ChannelHandler[]{new SslHandler(serverEngine)});
            }
            if (SecurityNetty4Transport.this.authenticator != null) {
                ch.pipeline().addFirst(new ChannelHandler[]{new IpFilterRemoteAddressFilter(SecurityNetty4Transport.this.authenticator, this.name)});
            }
        }
    }
}

