/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.oauth2;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.security.action.token.CreateTokenAction;
import org.elasticsearch.xpack.security.action.token.CreateTokenRequest;
import org.elasticsearch.xpack.security.action.token.CreateTokenResponse;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public final class RestGetTokenAction
extends SecurityBaseRestHandler {
    static final ConstructingObjectParser<CreateTokenRequest, Void> PARSER = new ConstructingObjectParser("token_request", a -> new CreateTokenRequest((String)a[0], (String)a[1], (SecureString)a[2], (String)a[3]));

    public RestGetTokenAction(Settings settings, RestController controller, XPackLicenseState xPackLicenseState) {
        super(settings, xPackLicenseState);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/oauth2/token", (RestHandler)this);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            CreateTokenRequest tokenRequest = (CreateTokenRequest)((Object)PARSER.parse(parser, null));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((Action)CreateTokenAction.INSTANCE, (ActionRequest)tokenRequest, (ActionListener)new CreateTokenResponseActionListener((RestChannel)channel, request, this.logger));
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("grant_type", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("username", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), parser -> new SecureString(Arrays.copyOfRange(parser.textCharacters(), parser.textOffset(), parser.textOffset() + parser.textLength())), new ParseField("password", new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("scope", new String[0]));
    }

    static enum TokenRequestError {
        INVALID_REQUEST,
        INVALID_CLIENT,
        INVALID_GRANT,
        UNAUTHORIZED_CLIENT,
        UNSUPPORTED_GRANT_TYPE,
        INVALID_SCOPE;

    }

    static class CreateTokenResponseActionListener
    implements ActionListener<CreateTokenResponse> {
        private final RestChannel channel;
        private final RestRequest request;
        private final Logger logger;

        CreateTokenResponseActionListener(RestChannel restChannel, RestRequest restRequest, Logger logger) {
            this.channel = restChannel;
            this.request = restRequest;
            this.logger = logger;
        }

        public void onResponse(CreateTokenResponse createTokenResponse) {
            try (XContentBuilder builder = this.channel.newBuilder();){
                this.channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, createTokenResponse.toXContent(builder, (ToXContent.Params)this.request)));
            }
            catch (IOException e) {
                this.onFailure(e);
            }
        }

        public void onFailure(Exception e) {
            if (e instanceof ActionRequestValidationException) {
                ActionRequestValidationException validationException = (ActionRequestValidationException)e;
                try (XContentBuilder builder = this.channel.newErrorBuilder();){
                    TokenRequestError error = validationException.validationErrors().stream().anyMatch(s -> s.contains("grant_type")) ? TokenRequestError.UNSUPPORTED_GRANT_TYPE : TokenRequestError.INVALID_REQUEST;
                    builder.startObject().field("error", error.toString().toLowerCase(Locale.ROOT)).field("error_description", validationException.getMessage()).endObject();
                    this.channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, builder));
                }
                catch (IOException ioe) {
                    ioe.addSuppressed(e);
                    this.sendFailure(ioe);
                }
            } else {
                this.sendFailure(e);
            }
        }

        void sendFailure(Exception e) {
            try {
                this.channel.sendResponse((RestResponse)new BytesRestResponse(this.channel, e));
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.error("failed to send failure response", (Throwable)inner);
            }
        }
    }
}

