/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.io.Closeable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.ldap.PoolingSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.SearchGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.UserAttributeGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.CharArrays;
import org.elasticsearch.xpack.ssl.SSLService;

class LdapUserSearchSessionFactory
extends PoolingSessionFactory {
    private static final String DEFAULT_USERNAME_ATTRIBUTE = "uid";
    static final String SEARCH_PREFIX = "user_search.";
    static final Setting<String> SEARCH_ATTRIBUTE = new Setting("user_search.attribute", "uid", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    private static final Setting<String> SEARCH_BASE_DN = Setting.simpleString((String)"user_search.base_dn", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<String> SEARCH_FILTER = Setting.simpleString((String)"user_search.filter", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<LdapSearchScope> SEARCH_SCOPE = new Setting("user_search.scope", (String)null, s -> LdapSearchScope.resolve(s, LdapSearchScope.SUB_TREE), new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Boolean> POOL_ENABLED = Setting.boolSetting((String)"user_search.pool.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final String userSearchBaseDn;
    private final LdapSearchScope scope;
    private final String searchFilter;

    LdapUserSearchSessionFactory(RealmConfig config, SSLService sslService) throws LDAPException {
        super(config, sslService, LdapUserSearchSessionFactory.groupResolver(config.settings()), POOL_ENABLED, () -> LdapUserSearchSessionFactory.bindRequest(config.settings()), () -> {
            if (BIND_DN.exists(config.settings())) {
                return (String)BIND_DN.get(config.settings());
            }
            return (String)SEARCH_BASE_DN.get(config.settings());
        });
        Settings settings = config.settings();
        if (!SEARCH_BASE_DN.exists(settings)) {
            throw new IllegalArgumentException("[" + RealmSettings.getFullSettingKey(config, SEARCH_BASE_DN) + "] must be specified");
        }
        this.userSearchBaseDn = (String)SEARCH_BASE_DN.get(settings);
        this.scope = (LdapSearchScope)((Object)SEARCH_SCOPE.get(settings));
        this.searchFilter = LdapUserSearchSessionFactory.getSearchFilter(config);
        this.logger.info("Realm [{}] is in user-search mode - base_dn=[{}], search filter=[{}]", (Object)config.name(), (Object)this.userSearchBaseDn, (Object)this.searchFilter);
    }

    static SimpleBindRequest bindRequest(Settings settings) {
        if (BIND_DN.exists(settings)) {
            return new SimpleBindRequest((String)BIND_DN.get(settings), (String)BIND_PASSWORD.get(settings));
        }
        return new SimpleBindRequest();
    }

    static boolean hasUserSearchSettings(RealmConfig config) {
        return !config.settings().getByPrefix(SEARCH_PREFIX).isEmpty();
    }

    @Override
    void getSessionWithPool(LDAPConnectionPool connectionPool, String user, SecureString password, ActionListener<LdapSession> listener) {
        this.findUser(user, (LDAPInterface)connectionPool, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null) {
                listener.onResponse(null);
            } else {
                String dn = entry.getDN();
                byte[] passwordBytes = CharArrays.toUtf8Bytes(password.getChars());
                try {
                    connectionPool.bindAndRevertAuthentication((BindRequest)new SimpleBindRequest(dn, passwordBytes));
                    listener.onResponse((Object)new LdapSession(this.logger, this.config, (LDAPInterface)connectionPool, dn, this.groupResolver, this.metaDataResolver, this.timeout, entry.getAttributes()));
                }
                catch (LDAPException e) {
                    listener.onFailure((Exception)((Object)e));
                }
                finally {
                    Arrays.fill(passwordBytes, (byte)0);
                }
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void getSessionWithoutPool(String user, SecureString password, ActionListener<LdapSession> listener) {
        boolean success = false;
        LDAPConnection connection = null;
        try {
            connection = this.serverSet.getConnection();
            connection.bind((BindRequest)LdapUserSearchSessionFactory.bindRequest(this.config.settings()));
            LDAPConnection finalConnection = connection;
            this.findUser(user, (LDAPInterface)connection, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                IOUtils.close((Closeable[])new Closeable[]{finalConnection});
                if (entry == null) {
                    listener.onResponse(null);
                    return;
                }
                String dn = entry.getDN();
                boolean sessionCreated = false;
                LDAPConnection userConnection = null;
                byte[] passwordBytes = CharArrays.toUtf8Bytes(password.getChars());
                try {
                    userConnection = this.serverSet.getConnection();
                    userConnection.bind((BindRequest)new SimpleBindRequest(dn, passwordBytes));
                    LdapSession session = new LdapSession(this.logger, this.config, (LDAPInterface)userConnection, dn, this.groupResolver, this.metaDataResolver, this.timeout, entry.getAttributes());
                    sessionCreated = true;
                    listener.onResponse((Object)session);
                }
                catch (Exception e) {
                    try {
                        listener.onFailure(e);
                    }
                    catch (Throwable throwable) {
                        Arrays.fill(passwordBytes, (byte)0);
                        if (sessionCreated) throw throwable;
                        IOUtils.close((Closeable[])new Closeable[]{userConnection});
                        throw throwable;
                    }
                    Arrays.fill(passwordBytes, (byte)0);
                    if (sessionCreated) return;
                    IOUtils.close((Closeable[])new Closeable[]{userConnection});
                    return;
                }
                Arrays.fill(passwordBytes, (byte)0);
                if (sessionCreated) return;
                IOUtils.close((Closeable[])new Closeable[]{userConnection});
                return;
            }, e -> {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{finalConnection});
                listener.onFailure(e);
            }));
            return;
        }
        catch (LDAPException e2) {
            try {
                listener.onFailure((Exception)((Object)e2));
                if (success) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
            return;
        }
    }

    @Override
    public boolean supportsUnauthenticatedSession() {
        return true;
    }

    @Override
    void getUnauthenticatedSessionWithPool(LDAPConnectionPool connectionPool, String user, ActionListener<LdapSession> listener) {
        this.findUser(user, (LDAPInterface)connectionPool, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null) {
                listener.onResponse(null);
            } else {
                String dn = entry.getDN();
                LdapSession session = new LdapSession(this.logger, this.config, (LDAPInterface)connectionPool, dn, this.groupResolver, this.metaDataResolver, this.timeout, entry.getAttributes());
                listener.onResponse((Object)session);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void getUnauthenticatedSessionWithoutPool(String user, ActionListener<LdapSession> listener) {
        LDAPConnection connection = null;
        boolean success = false;
        try {
            connection = this.serverSet.getConnection();
            connection.bind((BindRequest)LdapUserSearchSessionFactory.bindRequest(this.config.settings()));
            LDAPConnection finalConnection = connection;
            this.findUser(user, (LDAPInterface)finalConnection, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                if (entry == null) {
                    listener.onResponse(null);
                    return;
                }
                boolean sessionCreated = false;
                try {
                    String dn = entry.getDN();
                    LdapSession session = new LdapSession(this.logger, this.config, (LDAPInterface)finalConnection, dn, this.groupResolver, this.metaDataResolver, this.timeout, entry.getAttributes());
                    sessionCreated = true;
                    listener.onResponse((Object)session);
                    if (sessionCreated) return;
                }
                catch (Throwable throwable) {
                    if (sessionCreated) throw throwable;
                    IOUtils.close((Closeable[])new Closeable[]{finalConnection});
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{finalConnection});
            }, arg_0 -> listener.onFailure(arg_0)));
            return;
        }
        catch (LDAPException e) {
            try {
                listener.onFailure((Exception)((Object)e));
                if (success) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
            return;
        }
    }

    private void findUser(String user, LDAPInterface ldapInterface, ActionListener<SearchResultEntry> listener) {
        Filter filter;
        try {
            filter = LdapUtils.createFilter(this.searchFilter, user);
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
            return;
        }
        LdapUtils.searchForEntry(ldapInterface, this.userSearchBaseDn, this.scope.scope(), filter, Math.toIntExact(this.timeout.seconds()), this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupResolver.attributes(), this.metaDataResolver.attributeNames()));
    }

    private static LdapSession.GroupsResolver groupResolver(Settings settings) {
        if (SearchGroupsResolver.BASE_DN.exists(settings)) {
            return new SearchGroupsResolver(settings);
        }
        return new UserAttributeGroupsResolver(settings);
    }

    static String getSearchFilter(RealmConfig config) {
        Settings settings = config.settings();
        boolean hasAttribute = SEARCH_ATTRIBUTE.exists(settings);
        boolean hasFilter = SEARCH_FILTER.exists(settings);
        if (hasAttribute && hasFilter) {
            throw new IllegalArgumentException("search attribute setting [" + RealmSettings.getFullSettingKey(config, SEARCH_ATTRIBUTE) + "] and filter setting [" + RealmSettings.getFullSettingKey(config, SEARCH_FILTER) + "] cannot be combined!");
        }
        if (hasFilter) {
            return (String)SEARCH_FILTER.get(settings);
        }
        if (hasAttribute) {
            return "(" + (String)SEARCH_ATTRIBUTE.get(settings) + "={0})";
        }
        return "(uid={0})";
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(SessionFactory.getSettings());
        settings.addAll(PoolingSessionFactory.getSettings());
        settings.add(SEARCH_BASE_DN);
        settings.add(SEARCH_SCOPE);
        settings.add(SEARCH_ATTRIBUTE);
        settings.add(POOL_ENABLED);
        settings.add(SEARCH_FILTER);
        settings.addAll(SearchGroupsResolver.getSettings());
        settings.addAll(UserAttributeGroupsResolver.getSettings());
        return settings;
    }
}

