/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectorySessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;

class ActiveDirectoryGroupsResolver
implements LdapSession.GroupsResolver {
    private static final String TOKEN_GROUPS = "tokenGroups";
    private final String baseDn;
    private final LdapSearchScope scope;
    private final boolean ignoreReferralErrors;

    ActiveDirectoryGroupsResolver(Settings settings) {
        this.baseDn = settings.get("group_search.base_dn", ActiveDirectorySessionFactory.buildDnFromDomain(settings.get("domain_name")));
        this.scope = LdapSearchScope.resolve(settings.get("group_search.scope"), LdapSearchScope.SUB_TREE);
        this.ignoreReferralErrors = (Boolean)SessionFactory.IGNORE_REFERRAL_ERRORS_SETTING.get(settings);
    }

    @Override
    public void resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes, ActionListener<List<String>> listener) {
        ActiveDirectoryGroupsResolver.buildGroupQuery(connection, userDn, timeout, this.ignoreReferralErrors, (ActionListener<Filter>)ActionListener.wrap(filter -> {
            if (filter == null) {
                listener.onResponse(Collections.emptyList());
            } else {
                logger.debug("group SID to DN [{}] search filter: [{}]", (Object)userDn, filter);
                LdapUtils.search(connection, this.baseDn, this.scope.scope(), filter, Math.toIntExact(timeout.seconds()), this.ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> {
                    List groups = results.stream().map(Entry::getDN).collect(Collectors.toList());
                    listener.onResponse(Collections.unmodifiableList(groups));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), "1.1");
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public String[] attributes() {
        return null;
    }

    static void buildGroupQuery(LDAPInterface connection, String userDn, TimeValue timeout, boolean ignoreReferralErrors, ActionListener<Filter> listener) {
        LdapUtils.searchForEntry(connection, userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, Math.toIntExact(timeout.seconds()), ignoreReferralErrors, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null || !entry.hasAttribute(TOKEN_GROUPS)) {
                listener.onResponse(null);
            } else {
                byte[][] tokenGroupSIDBytes = entry.getAttributeValueByteArrays(TOKEN_GROUPS);
                List orFilters = Arrays.stream(tokenGroupSIDBytes).map(sidBytes -> Filter.createEqualityFilter((String)"objectSid", (String)ActiveDirectoryGroupsResolver.binarySidToStringSid(sidBytes))).collect(Collectors.toList());
                listener.onResponse((Object)Filter.createORFilter(orFilters));
            }
        }, arg_0 -> listener.onFailure(arg_0)), TOKEN_GROUPS);
    }

    private static String binarySidToStringSid(byte[] SID) {
        String strSID = "S";
        long version = SID[0];
        strSID = strSID + "-" + Long.toString(version);
        long authority = SID[4];
        for (int i = 0; i < 4; ++i) {
            authority <<= 8;
            authority += (long)(SID[4 + i] & 0xFF);
        }
        strSID = strSID + "-" + Long.toString(authority);
        long count = SID[2];
        count <<= 8;
        count += (long)(SID[1] & 0xFF);
        int j = 0;
        while ((long)j < count) {
            long rid = SID[11 + j * 4] & 0xFF;
            for (int k = 1; k < 4; ++k) {
                rid <<= 8;
                rid += (long)(SID[11 - k + j * 4] & 0xFF);
            }
            strSID = strSID + "-" + Long.toString(rid);
            ++j;
        }
        return strSID;
    }
}

