/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.IOException;
import java.util.Base64;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.security.user.User;

public class Authentication {
    public static final String AUTHENTICATION_KEY = "_xpack_security_authentication";
    private final User user;
    private final RealmRef authenticatedBy;
    private final RealmRef lookedUpBy;
    private final Version version;

    public Authentication(User user, RealmRef authenticatedBy, RealmRef lookedUpBy) {
        this(user, authenticatedBy, lookedUpBy, Version.CURRENT);
    }

    public Authentication(User user, RealmRef authenticatedBy, RealmRef lookedUpBy, Version version) {
        this.user = Objects.requireNonNull(user);
        this.authenticatedBy = Objects.requireNonNull(authenticatedBy);
        this.lookedUpBy = lookedUpBy;
        this.version = version;
    }

    public Authentication(StreamInput in) throws IOException {
        this.user = User.readFrom(in);
        this.authenticatedBy = new RealmRef(in);
        this.lookedUpBy = in.readBoolean() ? new RealmRef(in) : null;
        this.version = in.getVersion();
    }

    public User getUser() {
        return this.user;
    }

    public RealmRef getAuthenticatedBy() {
        return this.authenticatedBy;
    }

    public RealmRef getLookedUpBy() {
        return this.lookedUpBy;
    }

    public Version getVersion() {
        return this.version;
    }

    public static Authentication readFromContext(ThreadContext ctx, CryptoService cryptoService, Settings settings, Version version, boolean signingEnabled) throws IOException, IllegalArgumentException {
        Authentication authentication = (Authentication)ctx.getTransient(AUTHENTICATION_KEY);
        if (authentication != null) {
            assert (ctx.getHeader(AUTHENTICATION_KEY) != null);
            return authentication;
        }
        String authenticationHeader = ctx.getHeader(AUTHENTICATION_KEY);
        if (authenticationHeader == null) {
            return null;
        }
        boolean shouldSign = Authentication.shouldSign(settings, version, signingEnabled);
        return Authentication.deserializeHeaderAndPutInContext(authenticationHeader, ctx, cryptoService, shouldSign, version);
    }

    public static Authentication getAuthentication(ThreadContext context) {
        return (Authentication)context.getTransient(AUTHENTICATION_KEY);
    }

    private static Authentication deserializeHeaderAndPutInContext(String header, ThreadContext ctx, CryptoService cryptoService, boolean signed, Version version) throws IOException {
        assert (ctx.getTransient(AUTHENTICATION_KEY) == null);
        Authentication authentication = Authentication.deserializeHeader(header, cryptoService, signed, version);
        ctx.putTransient(AUTHENTICATION_KEY, (Object)authentication);
        return authentication;
    }

    static Authentication deserializeHeader(String header, CryptoService cryptoService, boolean signed, Version version) throws IOException {
        byte[] bytes;
        StreamInput input;
        Version streamVersion;
        if (signed) {
            header = cryptoService.unsignAndVerify(header, version);
        }
        if (!(streamVersion = Version.readVersion((StreamInput)(input = StreamInput.wrap((byte[])(bytes = Base64.getDecoder().decode(header)))))).equals((Object)version) && !version.equals((Object)Version.V_5_4_0)) {
            throw new IllegalStateException("version mismatch. expected [" + version + "] but got [" + streamVersion + "]");
        }
        input.setVersion(version);
        return new Authentication(input);
    }

    void writeToContextIfMissing(ThreadContext context, CryptoService cryptoService, Settings settings, Version version, boolean signingEnabled) throws IOException, IllegalArgumentException {
        if (context.getTransient(AUTHENTICATION_KEY) != null) {
            if (context.getHeader(AUTHENTICATION_KEY) == null) {
                throw new IllegalStateException("authentication present as a transient but not a header");
            }
            return;
        }
        if (context.getHeader(AUTHENTICATION_KEY) != null) {
            boolean shouldSign = Authentication.shouldSign(settings, version, signingEnabled);
            Authentication.deserializeHeaderAndPutInContext(context.getHeader(AUTHENTICATION_KEY), context, cryptoService, shouldSign, version);
        } else {
            this.writeToContext(context, cryptoService, settings, version, signingEnabled);
        }
    }

    public static boolean shouldSign(Settings settings, Version version, boolean signingEnabled) {
        if (version.equals((Object)Version.V_5_4_0)) {
            return false;
        }
        return signingEnabled && ((Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings) == false || version.before(Version.V_5_4_0));
    }

    public void writeToContext(ThreadContext ctx, CryptoService cryptoService, Settings settings, Version version, boolean signingEnabled) throws IOException, IllegalArgumentException {
        this.ensureContextDoesNotContainAuthentication(ctx);
        String header = this.encode();
        if (Authentication.shouldSign(settings, version, signingEnabled)) {
            header = cryptoService.sign(header, version);
        }
        ctx.putTransient(AUTHENTICATION_KEY, (Object)this);
        ctx.putHeader(AUTHENTICATION_KEY, header);
    }

    void ensureContextDoesNotContainAuthentication(ThreadContext ctx) {
        if (ctx.getTransient(AUTHENTICATION_KEY) != null) {
            if (ctx.getHeader(AUTHENTICATION_KEY) == null) {
                throw new IllegalStateException("authentication present as a transient but not a header");
            }
            throw new IllegalStateException("authentication is already present in the context");
        }
    }

    String encode() throws IOException {
        BytesStreamOutput output = new BytesStreamOutput();
        output.setVersion(this.version);
        Version.writeVersion((Version)this.version, (StreamOutput)output);
        this.writeTo((StreamOutput)output);
        return Base64.getEncoder().encodeToString(BytesReference.toBytes((BytesReference)output.bytes()));
    }

    void writeTo(StreamOutput out) throws IOException {
        User.writeTo(this.user, out);
        this.authenticatedBy.writeTo(out);
        if (this.lookedUpBy != null) {
            out.writeBoolean(true);
            this.lookedUpBy.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authentication that = (Authentication)o;
        if (!this.user.equals(that.user)) {
            return false;
        }
        if (!this.authenticatedBy.equals(that.authenticatedBy)) {
            return false;
        }
        if (this.lookedUpBy != null ? !this.lookedUpBy.equals(that.lookedUpBy) : that.lookedUpBy != null) {
            return false;
        }
        return this.version.equals((Object)that.version);
    }

    public int hashCode() {
        int result = this.user.hashCode();
        result = 31 * result + this.authenticatedBy.hashCode();
        result = 31 * result + (this.lookedUpBy != null ? this.lookedUpBy.hashCode() : 0);
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public static class RealmRef {
        private final String nodeName;
        private final String name;
        private final String type;

        public RealmRef(String name, String type, String nodeName) {
            this.nodeName = nodeName;
            this.name = name;
            this.type = type;
        }

        public RealmRef(StreamInput in) throws IOException {
            this.nodeName = in.readString();
            this.name = in.readString();
            this.type = in.readString();
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeName);
            out.writeString(this.name);
            out.writeString(this.type);
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RealmRef realmRef = (RealmRef)o;
            if (!this.nodeName.equals(realmRef.nodeName)) {
                return false;
            }
            if (!this.name.equals(realmRef.name)) {
                return false;
            }
            return this.type.equals(realmRef.type);
        }

        public int hashCode() {
            int result = this.nodeName.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

