/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Map;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.transport.netty3.SecurityNetty3Transport;
import org.elasticsearch.xpack.security.transport.netty4.SecurityNetty4Transport;
import org.elasticsearch.xpack.ssl.SSLService;

class PkiRealmBootstrapCheck
implements BootstrapCheck {
    private final SSLService sslService;
    private final Settings settings;

    PkiRealmBootstrapCheck(Settings settings, SSLService sslService) {
        this.settings = settings;
        this.sslService = sslService;
    }

    public boolean check() {
        boolean pkiRealmEnabled = this.settings.getGroups(RealmSettings.PREFIX).values().stream().filter(s -> "pki".equals(s.get("type"))).anyMatch(s -> s.getAsBoolean("enabled", Boolean.valueOf(true)));
        if (pkiRealmEnabled) {
            boolean httpSsl = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(this.settings);
            Settings httpSSLSettings = SSLService.getHttpTransportSSLSettings(this.settings);
            boolean httpClientAuth = this.sslService.isSSLClientAuthEnabled(httpSSLSettings);
            if (httpSsl && httpClientAuth) {
                return false;
            }
            boolean ssl = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings);
            Settings transportSSLSettings = this.settings.getByPrefix(Security.setting("transport.ssl."));
            boolean clientAuthEnabled = this.sslService.isSSLClientAuthEnabled(transportSSLSettings);
            if (ssl && clientAuthEnabled) {
                return false;
            }
            Map groupedSettings = this.settings.getGroups("transport.profiles.");
            for (Map.Entry entry : groupedSettings.entrySet()) {
                Settings profileSettings = (Settings)entry.getValue();
                if (!SecurityNetty4Transport.isProfileSSLEnabled(profileSettings, ssl) || !this.sslService.isSSLClientAuthEnabled(SecurityNetty3Transport.profileSslSettings(profileSettings), transportSSLSettings)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String errorMessage() {
        return "A PKI realm is enabled but cannot be used as neither HTTP or Transport have SSL and client authentication enabled";
    }

    public boolean alwaysEnforce() {
        return true;
    }
}

