/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.email.attachment;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.notification.email.attachment.EmailAttachmentParser;

public class EmailAttachments
implements ToXContent {
    public static final EmailAttachments EMPTY_ATTACHMENTS = new EmailAttachments(Collections.emptyList());
    private final Collection<EmailAttachmentParser.EmailAttachment> attachments;

    public EmailAttachments(Collection<EmailAttachmentParser.EmailAttachment> attachments) {
        this.attachments = attachments;
    }

    public Collection<EmailAttachmentParser.EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.attachments != null && this.attachments.size() > 0) {
            builder.startObject(Fields.ATTACHMENTS.getPreferredName());
            for (EmailAttachmentParser.EmailAttachment attachment : this.attachments) {
                attachment.toXContent(builder, params);
            }
            builder.endObject();
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailAttachments other = (EmailAttachments)o;
        return Objects.equals(this.attachments, other.attachments);
    }

    public int hashCode() {
        return Objects.hash(this.attachments);
    }

    public static interface Fields {
        public static final ParseField ATTACHMENTS = new ParseField("attachments", new String[0]);
    }
}

