/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils.time;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.mapper.DateFieldMapper;

public final class TimeUtils {
    private TimeUtils() {
    }

    public static long dateStringToEpoch(String date) {
        try {
            long epoch = Long.parseLong(date);
            if (date.trim().length() <= 10) {
                return epoch * 1000L;
            }
            return epoch;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.parser().parseMillis(date);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1L;
            }
        }
    }

    public static void checkNonNegativeMultiple(TimeValue timeValue, TimeUnit baseUnit, ParseField field) {
        TimeUtils.checkNonNegative(timeValue, field);
        TimeUtils.checkMultiple(timeValue, baseUnit, field);
    }

    public static void checkPositiveMultiple(TimeValue timeValue, TimeUnit baseUnit, ParseField field) {
        TimeUtils.checkPositive(timeValue, field);
        TimeUtils.checkMultiple(timeValue, baseUnit, field);
    }

    private static void checkNonNegative(TimeValue timeValue, ParseField field) {
        long nanos = timeValue.getNanos();
        if (nanos < 0L) {
            throw new IllegalArgumentException(field.getPreferredName() + " cannot be less than 0. Value = " + timeValue.toString());
        }
    }

    private static void checkPositive(TimeValue timeValue, ParseField field) {
        long nanos = timeValue.getNanos();
        if (nanos <= 0L) {
            throw new IllegalArgumentException(field.getPreferredName() + " cannot be less or equal than 0. Value = " + timeValue.toString());
        }
    }

    public static void checkMultiple(TimeValue timeValue, TimeUnit baseUnit, ParseField field) {
        TimeValue base;
        long baseNanos;
        long nanos = timeValue.getNanos();
        if (nanos % (baseNanos = (base = new TimeValue(1L, baseUnit)).getNanos()) != 0L) {
            throw new IllegalArgumentException(field.getPreferredName() + " has to be a multiple of " + base.toString() + "; actual was '" + timeValue.toString() + "'");
        }
    }
}

