/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.DataLoadParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.FlushJobParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.LengthEncodedWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.ModelPlotConfigWriter;

public class ControlMsgToProcessWriter {
    public static final int FLUSH_SPACES_LENGTH = 8192;
    private static final String FLUSH_MESSAGE_CODE = "f";
    private static final String INTERIM_MESSAGE_CODE = "i";
    public static final String RESET_BUCKETS_MESSAGE_CODE = "r";
    private static final String ADVANCE_TIME_MESSAGE_CODE = "t";
    private static final String SKIP_TIME_MESSAGE_CODE = "s";
    public static final String UPDATE_MESSAGE_CODE = "u";
    private static AtomicLong ms_FlushNumber = new AtomicLong(1L);
    private final LengthEncodedWriter lengthEncodedWriter;
    private final int numberOfAnalysisFields;

    public ControlMsgToProcessWriter(LengthEncodedWriter lengthEncodedWriter, int numberOfAnalysisFields) {
        this.lengthEncodedWriter = Objects.requireNonNull(lengthEncodedWriter);
        this.numberOfAnalysisFields = numberOfAnalysisFields;
    }

    public static ControlMsgToProcessWriter create(OutputStream os, int numberOfAnalysisFields) {
        return new ControlMsgToProcessWriter(new LengthEncodedWriter(os), numberOfAnalysisFields);
    }

    public void writeFlushControlMessage(FlushJobParams params) throws IOException {
        if (params.shouldSkipTime()) {
            this.writeMessage(SKIP_TIME_MESSAGE_CODE + params.getSkipTime());
        }
        if (params.shouldAdvanceTime()) {
            this.writeMessage(ADVANCE_TIME_MESSAGE_CODE + params.getAdvanceTime());
        }
        if (params.shouldCalculateInterim()) {
            this.writeControlCodeFollowedByTimeRange(INTERIM_MESSAGE_CODE, params.getStart(), params.getEnd());
        }
    }

    public String writeFlushMessage() throws IOException {
        String flushId = Long.toString(ms_FlushNumber.getAndIncrement());
        this.writeMessage(FLUSH_MESSAGE_CODE + flushId);
        char[] spaces = new char[8192];
        Arrays.fill(spaces, ' ');
        this.writeMessage(new String(spaces));
        this.lengthEncodedWriter.flush();
        return flushId;
    }

    public void writeResetBucketsMessage(DataLoadParams params) throws IOException {
        this.writeControlCodeFollowedByTimeRange(RESET_BUCKETS_MESSAGE_CODE, params.getStart(), params.getEnd());
    }

    private void writeControlCodeFollowedByTimeRange(String code, String start, String end) throws IOException {
        StringBuilder message = new StringBuilder(code);
        if (!start.isEmpty()) {
            message.append(start);
            message.append(' ');
            message.append(end);
        }
        this.writeMessage(message.toString());
    }

    public void writeUpdateModelPlotMessage(ModelPlotConfig modelPlotConfig) throws IOException {
        StringWriter configWriter = new StringWriter();
        configWriter.append(UPDATE_MESSAGE_CODE).append("[modelPlotConfig]\n");
        new ModelPlotConfigWriter(modelPlotConfig, configWriter).write();
        this.writeMessage(configWriter.toString());
    }

    public void writeUpdateDetectorRulesMessage(int detectorIndex, List<DetectionRule> rules) throws IOException {
        StringWriter configWriter = new StringWriter();
        configWriter.append(UPDATE_MESSAGE_CODE).append("[detectorRules]\n");
        configWriter.append("detectorIndex=").append(Integer.toString(detectorIndex)).append("\n");
        configWriter.append("rulesJson=");
        XContentBuilder builder = JsonXContent.contentBuilder();
        builder.startArray();
        for (DetectionRule rule : rules) {
            rule.toXContent(builder, ToXContent.EMPTY_PARAMS);
        }
        builder.endArray();
        configWriter.append(builder.string());
        this.writeMessage(configWriter.toString());
    }

    private void writeMessage(String message) throws IOException {
        this.lengthEncodedWriter.writeNumFields(this.numberOfAnalysisFields + 2);
        for (int i = -1; i < this.numberOfAnalysisFields; ++i) {
            this.lengthEncodedWriter.writeField("");
        }
        this.lengthEncodedWriter.writeField(message);
    }
}

