/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.ml.job.config.DataDescription;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.CannotParseTimestampException;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DataToProcessWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DateFormatDateTransformer;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DateTransformer;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DoubleDateTransformer;

public abstract class AbstractDataToProcessWriter
implements DataToProcessWriter {
    private static final int TIME_FIELD_OUT_INDEX = 0;
    private static final long MS_IN_SECOND = 1000L;
    private final boolean includeControlField;
    protected final AutodetectProcess autodetectProcess;
    protected final DataDescription dataDescription;
    protected final AnalysisConfig analysisConfig;
    protected final DataCountsReporter dataCountsReporter;
    private final Logger logger;
    private final DateTransformer dateTransformer;
    private long latencySeconds;
    protected Map<String, Integer> inFieldIndexes;
    protected List<InputOutputMap> inputOutputMap;
    private long latestEpochMs;
    private long latestEpochMsThisUpload;

    protected AbstractDataToProcessWriter(boolean includeControlField, AutodetectProcess autodetectProcess, DataDescription dataDescription, AnalysisConfig analysisConfig, DataCountsReporter dataCountsReporter, Logger logger) {
        this.includeControlField = includeControlField;
        this.autodetectProcess = Objects.requireNonNull(autodetectProcess);
        this.dataDescription = Objects.requireNonNull(dataDescription);
        this.analysisConfig = Objects.requireNonNull(analysisConfig);
        this.dataCountsReporter = Objects.requireNonNull(dataCountsReporter);
        this.logger = Objects.requireNonNull(logger);
        this.latencySeconds = analysisConfig.getLatency() == null ? 0L : analysisConfig.getLatency().seconds();
        Date date = dataCountsReporter.getLatestRecordTime();
        this.latestEpochMsThisUpload = 0L;
        this.latestEpochMs = 0L;
        if (date != null) {
            this.latestEpochMs = date.getTime();
        }
        boolean isDateFormatString = dataDescription.isTransformTime() && !dataDescription.isEpochMs();
        this.dateTransformer = isDateFormatString ? new DateFormatDateTransformer(dataDescription.getTimeFormat()) : new DoubleDateTransformer(dataDescription.isEpochMs());
    }

    void buildFieldIndexMapping(String[] header) throws IOException {
        Collection<String> inputFields = this.inputFields();
        this.inFieldIndexes = this.inputFieldIndexes(header, inputFields);
        this.checkForMissingFields(inputFields, this.inFieldIndexes, header);
        this.inputOutputMap = this.createInputOutputMap(this.inFieldIndexes);
        this.dataCountsReporter.setAnalysedFieldsPerRecord(this.analysisConfig.analysisFields().size());
    }

    @Override
    public void writeHeader() throws IOException {
        Map<String, Integer> outFieldIndexes = this.outputFieldIndexes();
        int numFields = outFieldIndexes.size();
        String[] record = new String[numFields];
        for (Map.Entry<String, Integer> entry : outFieldIndexes.entrySet()) {
            record[entry.getValue().intValue()] = entry.getKey();
        }
        this.autodetectProcess.writeRecord(record);
    }

    protected boolean transformTimeAndWrite(String[] record, long numberOfFieldsRead) throws IOException {
        long epochMs;
        try {
            epochMs = this.dateTransformer.transform(record[0]);
        }
        catch (CannotParseTimestampException e) {
            this.dataCountsReporter.reportDateParseError(numberOfFieldsRead);
            this.logger.error(e.getMessage());
            return false;
        }
        record[0] = Long.toString(epochMs / 1000L);
        if (epochMs / 1000L < this.latestEpochMs / 1000L - this.latencySeconds) {
            this.dataCountsReporter.reportOutOfOrderRecord(numberOfFieldsRead);
            if (epochMs > this.latestEpochMsThisUpload) {
                this.latestEpochMsThisUpload = epochMs;
                this.dataCountsReporter.reportLatestTimeIncrementalStats(this.latestEpochMsThisUpload);
            }
            return false;
        }
        this.latestEpochMsThisUpload = this.latestEpochMs = Math.max(this.latestEpochMs, epochMs);
        this.autodetectProcess.writeRecord(record);
        this.dataCountsReporter.reportRecordWritten(numberOfFieldsRead, epochMs);
        return true;
    }

    @Override
    public void flushStream() throws IOException {
        this.autodetectProcess.flushStream();
    }

    final Collection<String> inputFields() {
        Set<String> requiredFields = this.analysisConfig.analysisFields();
        requiredFields.add(this.dataDescription.getTimeField());
        return requiredFields;
    }

    protected final Map<String, Integer> inputFieldIndexes(String[] header, Collection<String> inputFields) {
        List<String> headerList = Arrays.asList(header);
        HashMap<String, Integer> fieldIndexes = new HashMap<String, Integer>();
        for (String field : inputFields) {
            int index = headerList.indexOf(field);
            if (index < 0) continue;
            fieldIndexes.put(field, index);
        }
        return fieldIndexes;
    }

    Map<String, Integer> getInputFieldIndexes() {
        return this.inFieldIndexes;
    }

    protected final Map<String, Integer> outputFieldIndexes() {
        HashMap<String, Integer> fieldIndexes = new HashMap<String, Integer>();
        fieldIndexes.put(this.dataDescription.getTimeField(), 0);
        int index = 1;
        for (String field : this.analysisConfig.analysisFields()) {
            fieldIndexes.put(field, index++);
        }
        if (this.includeControlField) {
            fieldIndexes.put(".", index);
        }
        return fieldIndexes;
    }

    protected int outputFieldCount() {
        return this.analysisConfig.analysisFields().size() + (this.includeControlField ? 2 : 1);
    }

    protected Map<String, Integer> getOutputFieldIndexes() {
        return this.outputFieldIndexes();
    }

    private List<InputOutputMap> createInputOutputMap(Map<String, Integer> inFieldIndexes) {
        ArrayList<InputOutputMap> inputOutputMap = new ArrayList<InputOutputMap>();
        int outIndex = 0;
        Integer inIndex = inFieldIndexes.get(this.dataDescription.getTimeField());
        if (inIndex == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Input time field '%s' not found", this.dataDescription.getTimeField()));
        }
        inputOutputMap.add(new InputOutputMap(inIndex, outIndex));
        for (String field : this.analysisConfig.analysisFields()) {
            ++outIndex;
            inIndex = inFieldIndexes.get(field);
            if (inIndex == null) continue;
            inputOutputMap.add(new InputOutputMap(inIndex, outIndex));
        }
        return inputOutputMap;
    }

    protected List<InputOutputMap> getInputOutputMap() {
        return this.inputOutputMap;
    }

    protected abstract boolean checkForMissingFields(Collection<String> var1, Map<String, Integer> var2, String[] var3);

    protected class InputOutputMap {
        int inputIndex;
        int outputIndex;

        public InputOutputMap(int in, int out) {
            this.inputIndex = in;
            this.outputIndex = out;
        }
    }
}

