/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.params;

import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.TimeRange;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.utils.time.TimeUtils;

public class FlushJobParams {
    private final boolean calcInterim;
    private final TimeRange timeRange;
    private final Long advanceTimeSeconds;
    private final Long skipTimeSeconds;

    private FlushJobParams(boolean calcInterim, TimeRange timeRange, Long advanceTimeSeconds, Long skipTimeSeconds) {
        this.calcInterim = calcInterim;
        this.timeRange = Objects.requireNonNull(timeRange);
        this.advanceTimeSeconds = advanceTimeSeconds;
        this.skipTimeSeconds = skipTimeSeconds;
    }

    public boolean shouldCalculateInterim() {
        return this.calcInterim;
    }

    public boolean shouldAdvanceTime() {
        return this.advanceTimeSeconds != null;
    }

    public boolean shouldSkipTime() {
        return this.skipTimeSeconds != null;
    }

    public String getStart() {
        return this.timeRange.getStart();
    }

    public String getEnd() {
        return this.timeRange.getEnd();
    }

    public long getAdvanceTime() {
        if (!this.shouldAdvanceTime()) {
            throw new IllegalStateException();
        }
        return this.advanceTimeSeconds;
    }

    public long getSkipTime() {
        if (!this.shouldSkipTime()) {
            throw new IllegalStateException();
        }
        return this.skipTimeSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlushJobParams that = (FlushJobParams)o;
        return this.calcInterim == that.calcInterim && Objects.equals(this.timeRange, that.timeRange) && Objects.equals(this.advanceTimeSeconds, that.advanceTimeSeconds) && Objects.equals(this.skipTimeSeconds, that.skipTimeSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.calcInterim, this.timeRange, this.advanceTimeSeconds, this.skipTimeSeconds);
    }

    public static class Builder {
        private boolean calcInterim = false;
        private TimeRange timeRange = TimeRange.builder().build();
        private String advanceTime;
        private String skipTime;

        public Builder calcInterim(boolean value) {
            this.calcInterim = value;
            return this;
        }

        public Builder forTimeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public Builder advanceTime(String timestamp) {
            this.advanceTime = ExceptionsHelper.requireNonNull(timestamp, "advance_time");
            return this;
        }

        public Builder skipTime(String timestamp) {
            this.skipTime = ExceptionsHelper.requireNonNull(timestamp, "skip_time");
            return this;
        }

        public FlushJobParams build() {
            this.checkValidFlushArgumentsCombination();
            Long advanceTimeSeconds = this.parseTimeParam("advance_time", this.advanceTime);
            Long skipTimeSeconds = this.parseTimeParam("skip_time", this.skipTime);
            if (skipTimeSeconds != null && advanceTimeSeconds != null && advanceTimeSeconds <= skipTimeSeconds) {
                throw ExceptionsHelper.badRequestException("advance_time [" + this.advanceTime + "] must be later than skip_time [" + this.skipTime + "]", new Object[0]);
            }
            return new FlushJobParams(this.calcInterim, this.timeRange, advanceTimeSeconds, skipTimeSeconds);
        }

        private void checkValidFlushArgumentsCombination() {
            if (!this.calcInterim) {
                this.checkFlushParamIsEmpty("start", this.timeRange.getStart());
                this.checkFlushParamIsEmpty("end", this.timeRange.getEnd());
            } else if (!this.isValidTimeRange(this.timeRange)) {
                String msg = Messages.getMessage("Invalid flush parameters: ''{0}'' has not been specified.", "start");
                throw new IllegalArgumentException(msg);
            }
        }

        private Long parseTimeParam(String name, String value) {
            if (Strings.isNullOrEmpty((String)value)) {
                return null;
            }
            return this.paramToEpochIfValidOrThrow(name, value) / 1000L;
        }

        private long paramToEpochIfValidOrThrow(String paramName, String date) {
            if ("now".equals(date)) {
                return System.currentTimeMillis();
            }
            long epoch = 0L;
            if (!date.isEmpty() && (epoch = TimeUtils.dateStringToEpoch(date)) < 0L) {
                String msg = Messages.getMessage("Query param ''{0}'' with value ''{1}'' cannot be parsed as a date or converted to a number (epoch).", paramName, date);
                throw new ElasticsearchParseException(msg, new Object[0]);
            }
            return epoch;
        }

        private void checkFlushParamIsEmpty(String paramName, String paramValue) {
            if (!paramValue.isEmpty()) {
                String msg = Messages.getMessage("Invalid flush parameters: unexpected ''{0}''.", paramName);
                throw new IllegalArgumentException(msg);
            }
        }

        private boolean isValidTimeRange(TimeRange timeRange) {
            return !timeRange.getStart().isEmpty() || timeRange.getStart().isEmpty() && timeRange.getEnd().isEmpty();
        }
    }
}

