/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.MlFilter;
import org.elasticsearch.xpack.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.ml.job.process.NativeController;
import org.elasticsearch.xpack.ml.job.process.ProcessCtrl;
import org.elasticsearch.xpack.ml.job.process.ProcessPipes;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.AnalysisLimitsWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.FieldConfigWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.ModelPlotConfigWriter;

public class AutodetectBuilder {
    private static final String CONF_EXTENSION = ".conf";
    private static final String LIMIT_CONFIG_ARG = "--limitconfig=";
    private static final String MODEL_PLOT_CONFIG_ARG = "--modelplotconfig=";
    private static final String FIELD_CONFIG_ARG = "--fieldconfig=";
    private Job job;
    private List<Path> filesToDelete;
    private Logger logger;
    private Set<MlFilter> referencedFilters;
    private Quantiles quantiles;
    private Environment env;
    private Settings settings;
    private NativeController controller;
    private ProcessPipes processPipes;

    public AutodetectBuilder(Job job, List<Path> filesToDelete, Logger logger, Environment env, Settings settings, NativeController controller, ProcessPipes processPipes) {
        this.env = env;
        this.settings = settings;
        this.controller = controller;
        this.processPipes = processPipes;
        this.job = Objects.requireNonNull(job);
        this.filesToDelete = Objects.requireNonNull(filesToDelete);
        this.logger = Objects.requireNonNull(logger);
        this.referencedFilters = new HashSet<MlFilter>();
    }

    public AutodetectBuilder referencedFilters(Set<MlFilter> filters) {
        this.referencedFilters = filters;
        return this;
    }

    public AutodetectBuilder quantiles(Quantiles quantiles) {
        this.quantiles = quantiles;
        return this;
    }

    public void build() throws IOException, TimeoutException {
        List<String> command = ProcessCtrl.buildAutodetectCommand(this.env, this.settings, this.job, this.logger, this.controller.getPid());
        this.buildLimits(command);
        this.buildModelPlotConfig(command);
        this.buildQuantiles(command);
        this.buildFieldConfig(command);
        this.processPipes.addArgs(command);
        this.controller.startProcess(command);
    }

    private void buildLimits(List<String> command) throws IOException {
        if (this.job.getAnalysisLimits() != null) {
            Path limitConfigFile = Files.createTempFile(this.env.tmpFile(), "limitconfig", CONF_EXTENSION, new FileAttribute[0]);
            this.filesToDelete.add(limitConfigFile);
            AutodetectBuilder.writeLimits(this.job.getAnalysisLimits(), limitConfigFile);
            String limits = LIMIT_CONFIG_ARG + limitConfigFile.toString();
            command.add(limits);
        }
    }

    private static void writeLimits(AnalysisLimits options, Path emptyConfFile) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(emptyConfFile, new OpenOption[0]), StandardCharsets.UTF_8);){
            new AnalysisLimitsWriter(options, osw).write();
        }
    }

    private void buildModelPlotConfig(List<String> command) throws IOException {
        if (this.job.getModelPlotConfig() != null) {
            Path modelPlotConfigFile = Files.createTempFile(this.env.tmpFile(), "modelplotconfig", CONF_EXTENSION, new FileAttribute[0]);
            this.filesToDelete.add(modelPlotConfigFile);
            AutodetectBuilder.writeModelPlotConfig(this.job.getModelPlotConfig(), modelPlotConfigFile);
            String modelPlotConfig = MODEL_PLOT_CONFIG_ARG + modelPlotConfigFile.toString();
            command.add(modelPlotConfig);
        }
    }

    private static void writeModelPlotConfig(ModelPlotConfig config, Path emptyConfFile) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(emptyConfFile, new OpenOption[0]), StandardCharsets.UTF_8);){
            new ModelPlotConfigWriter(config, osw).write();
        }
    }

    private void buildQuantiles(List<String> command) throws IOException {
        if (this.quantiles != null && !this.quantiles.getQuantileState().isEmpty()) {
            this.logger.info("Restoring quantiles for job '" + this.job.getId() + "'");
            Path normalizersStateFilePath = ProcessCtrl.writeNormalizerInitState(this.job.getId(), this.quantiles.getQuantileState(), this.env);
            String quantilesStateFileArg = "--quantilesState=" + normalizersStateFilePath;
            command.add(quantilesStateFileArg);
            command.add("--deleteStateFiles");
        }
    }

    private void buildFieldConfig(List<String> command) throws IOException {
        if (this.job.getAnalysisConfig() != null) {
            Path fieldConfigFile = Files.createTempFile(this.env.tmpFile(), "fieldconfig", CONF_EXTENSION, new FileAttribute[0]);
            this.filesToDelete.add(fieldConfigFile);
            try (OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(fieldConfigFile, new OpenOption[0]), StandardCharsets.UTF_8);){
                new FieldConfigWriter(this.job.getAnalysisConfig(), this.referencedFilters, osw, this.logger).write();
            }
            String fieldConfig = FIELD_CONFIG_ARG + fieldConfigFile.toString();
            command.add(fieldConfig);
        }
    }
}

