/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public enum JobState implements ToXContent,
Writeable
{
    CLOSING,
    CLOSED,
    OPENED,
    FAILED,
    OPENING;


    public static JobState fromString(String name) {
        return JobState.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static JobState fromStream(StreamInput in) throws IOException {
        return (JobState)in.readEnum(JobState.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        JobState state = this;
        if (this == OPENING && out.getVersion().before(Version.V_5_5_0)) {
            state = CLOSED;
        }
        out.writeEnum((Enum)state);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.value(this.name().toLowerCase(Locale.ROOT));
        return builder;
    }

    public boolean isFragment() {
        return true;
    }

    public boolean isAnyOf(JobState ... candidates) {
        return Arrays.stream(candidates).anyMatch(candidate -> this == candidate);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

