/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJob;
import org.elasticsearch.xpack.ml.datafeed.DefaultFrequency;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.job.config.DataDescription;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.BucketsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.notifications.Auditor;

public class DatafeedJobBuilder {
    private final Client client;
    private final JobProvider jobProvider;
    private final Auditor auditor;
    private final Supplier<Long> currentTimeSupplier;

    public DatafeedJobBuilder(Client client, JobProvider jobProvider, Auditor auditor, Supplier<Long> currentTimeSupplier) {
        this.client = Objects.requireNonNull(client);
        this.jobProvider = Objects.requireNonNull(jobProvider);
        this.auditor = Objects.requireNonNull(auditor);
        this.currentTimeSupplier = Objects.requireNonNull(currentTimeSupplier);
    }

    void build(Job job, DatafeedConfig datafeed, ActionListener<DatafeedJob> listener) {
        Consumer<Context> contextHanlder = context -> {
            Duration frequency = DatafeedJobBuilder.getFrequencyOrDefault(datafeed, job);
            Duration queryDelay = Duration.ofMillis(datafeed.getQueryDelay().millis());
            DatafeedJob datafeedJob = new DatafeedJob(job.getId(), DatafeedJobBuilder.buildDataDescription(job), frequency.toMillis(), queryDelay.toMillis(), context.dataExtractorFactory, this.client, this.auditor, this.currentTimeSupplier, context.latestFinalBucketEndMs, context.latestRecordTimeMs);
            listener.onResponse((Object)datafeedJob);
        };
        Context context2 = new Context();
        ActionListener dataExtractorFactoryHandler = ActionListener.wrap(dataExtractorFactory -> {
            context.dataExtractorFactory = dataExtractorFactory;
            contextHanlder.accept(context2);
        }, e -> {
            this.auditor.error(job.getId(), e.getMessage());
            listener.onFailure(e);
        });
        Consumer<DataCounts> dataCountsHandler = dataCounts -> {
            if (dataCounts.getLatestRecordTimeStamp() != null) {
                context.latestRecordTimeMs = dataCounts.getLatestRecordTimeStamp().getTime();
            }
            DataExtractorFactory.create(this.client, datafeed, job, (ActionListener<DataExtractorFactory>)dataExtractorFactoryHandler);
        };
        Consumer<QueryPage<Bucket>> bucketsHandler = buckets -> {
            if (buckets.results().size() == 1) {
                TimeValue bucketSpan = job.getAnalysisConfig().getBucketSpan();
                context.latestFinalBucketEndMs = ((Bucket)((Object)((Object)buckets.results().get(0)))).getTimestamp().getTime() + bucketSpan.millis() - 1L;
            }
            this.jobProvider.dataCounts(job.getId(), dataCountsHandler, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
        };
        BucketsQueryBuilder.BucketsQuery latestBucketQuery = new BucketsQueryBuilder().sortField(Result.TIMESTAMP.getPreferredName()).sortDescending(true).size(1).includeInterim(false).build();
        this.jobProvider.bucketsViaInternalClient(job.getId(), latestBucketQuery, bucketsHandler, e -> {
            if (e instanceof ResourceNotFoundException) {
                QueryPage empty = new QueryPage(Collections.emptyList(), 0L, Bucket.RESULT_TYPE_FIELD);
                bucketsHandler.accept(empty);
            } else {
                listener.onFailure(e);
            }
        });
    }

    private static Duration getFrequencyOrDefault(DatafeedConfig datafeed, Job job) {
        TimeValue frequency = datafeed.getFrequency();
        TimeValue bucketSpan = job.getAnalysisConfig().getBucketSpan();
        return frequency == null ? DefaultFrequency.ofBucketSpan(bucketSpan.seconds()) : Duration.ofSeconds(frequency.seconds());
    }

    private static DataDescription buildDataDescription(Job job) {
        DataDescription.Builder dataDescription = new DataDescription.Builder();
        dataDescription.setFormat(DataDescription.DataFormat.XCONTENT);
        if (job.getDataDescription() != null) {
            dataDescription.setTimeField(job.getDataDescription().getTimeField());
        }
        dataDescription.setTimeFormat("epoch_ms");
        return dataDescription.build();
    }

    private static class Context {
        volatile long latestFinalBucketEndMs = -1L;
        volatile long latestRecordTimeMs = -1L;
        volatile DataExtractorFactory dataExtractorFactory;

        private Context() {
        }
    }
}

