/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class GetDatafeedsAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetDatafeedsAction INSTANCE = new GetDatafeedsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/datafeeds/get";
    public static final String ALL = "_all";

    private GetDatafeedsAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportMasterNodeReadAction<Request, Response> {
        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(settings, GetDatafeedsAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            QueryPage<DatafeedConfig> response;
            this.logger.debug("Get datafeed '{}'", (Object)request.getDatafeedId());
            MlMetadata mlMetadata = (MlMetadata)state.metaData().custom("ml");
            if (mlMetadata == null) {
                mlMetadata = MlMetadata.EMPTY_METADATA;
            }
            if (GetDatafeedsAction.ALL.equals(request.getDatafeedId())) {
                ArrayList<DatafeedConfig> datafeedConfigs = new ArrayList<DatafeedConfig>(mlMetadata.getDatafeeds().values());
                response = new QueryPage<DatafeedConfig>(datafeedConfigs, datafeedConfigs.size(), DatafeedConfig.RESULTS_FIELD);
            } else {
                DatafeedConfig datafeed = mlMetadata.getDatafeed(request.getDatafeedId());
                if (datafeed == null) {
                    throw ExceptionsHelper.missingDatafeedException(request.getDatafeedId());
                }
                response = new QueryPage<DatafeedConfig>(Collections.singletonList(datafeed), 1L, DatafeedConfig.RESULTS_FIELD);
            }
            listener.onResponse((Object)new Response(response));
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<DatafeedConfig> datafeeds;

        public Response(QueryPage<DatafeedConfig> datafeeds) {
            this.datafeeds = datafeeds;
        }

        public Response() {
        }

        public QueryPage<DatafeedConfig> getResponse() {
            return this.datafeeds;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.datafeeds = new QueryPage(in, DatafeedConfig::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.datafeeds.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.datafeeds.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.datafeeds});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.datafeeds, other.datafeeds);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class RequestBuilder
    extends MasterNodeReadOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, GetDatafeedsAction action) {
            super(client, (Action)action, (MasterNodeReadRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        private String datafeedId;

        public Request(String datafeedId) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
        }

        Request() {
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.datafeedId = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.datafeedId);
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.datafeedId, other.datafeedId);
        }
    }
}

