/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.Counter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.Platforms;
import org.elasticsearch.xpack.XPackFeatureSet;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.JobState;
import org.elasticsearch.xpack.ml.job.process.NativeController;
import org.elasticsearch.xpack.ml.job.process.NativeControllerHolder;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.utils.StatsAccumulator;

public class MachineLearningFeatureSet
implements XPackFeatureSet {
    private static final List<String> mlPlatforms = Arrays.asList("darwin-x86_64", "linux-x86_64", "windows-x86_64");
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    private final ClusterService clusterService;
    private final Client client;
    private final Map<String, Object> nativeCodeInfo;

    @Inject
    public MachineLearningFeatureSet(Settings settings, ClusterService clusterService, Client client, @Nullable XPackLicenseState licenseState) {
        this.enabled = (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(settings);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.client = Objects.requireNonNull(client);
        this.licenseState = licenseState;
        Map<String, Object> nativeCodeInfo = NativeController.UNKNOWN_NATIVE_CODE_INFO;
        if (this.enabled && !XPackPlugin.transportClientMode(settings) && !XPackPlugin.isTribeClientNode(settings)) {
            try {
                NativeController nativeController;
                if (MachineLearningFeatureSet.isRunningOnMlPlatform(true) && (nativeController = NativeControllerHolder.getNativeController(settings)) != null) {
                    nativeCodeInfo = nativeController.getNativeCodeInfo();
                }
            }
            catch (IOException | TimeoutException e) {
                Loggers.getLogger(MachineLearningFeatureSet.class).error("Cannot get native code info for Machine Learning", (Throwable)e);
                throw new ElasticsearchException("Cannot communicate with Machine Learning native code", new Object[0]);
            }
        }
        this.nativeCodeInfo = nativeCodeInfo;
    }

    static boolean isRunningOnMlPlatform(boolean fatalIfNot) {
        return MachineLearningFeatureSet.isRunningOnMlPlatform(Constants.OS_NAME, Constants.OS_ARCH, fatalIfNot);
    }

    static boolean isRunningOnMlPlatform(String osName, String osArch, boolean fatalIfNot) {
        String platformName = Platforms.platformName((String)osName, (String)osArch);
        if (mlPlatforms.contains(platformName)) {
            return true;
        }
        if (fatalIfNot) {
            throw new ElasticsearchException("X-Pack is not supported and Machine Learning is not available for [" + platformName + "]; you can use the other X-Pack features (unsupported) by setting xpack.ml.enabled: false in elasticsearch.yml", new Object[0]);
        }
        return false;
    }

    @Override
    public String name() {
        return "ml";
    }

    @Override
    public String description() {
        return "Machine Learning for the Elastic Stack";
    }

    @Override
    public boolean available() {
        return this.licenseState != null && this.licenseState.isMachineLearningAllowed();
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public Map<String, Object> nativeCodeInfo() {
        return this.nativeCodeInfo;
    }

    @Override
    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        ClusterState state = this.clusterService.state();
        MlMetadata mlMetadata = (MlMetadata)state.getMetaData().custom("ml");
        if (mlMetadata == null) {
            listener.onResponse((Object)new Usage(this.available(), this.enabled, Collections.emptyMap(), Collections.emptyMap()));
        } else {
            new Usage.Retriever(this.client, mlMetadata, this.available(), this.enabled()).execute(listener);
        }
    }

    public static class Usage
    extends XPackFeatureSet.Usage {
        private static final String ALL = "_all";
        private static final String JOBS_FIELD = "jobs";
        private static final String DATAFEEDS_FIELD = "datafeeds";
        private static final String COUNT = "count";
        private static final String DETECTORS = "detectors";
        private static final String MODEL_SIZE = "model_size";
        private final Map<String, Object> jobsUsage;
        private final Map<String, Object> datafeedsUsage;

        public Usage(boolean available, boolean enabled, Map<String, Object> jobsUsage, Map<String, Object> datafeedsUsage) {
            super("ml", available, enabled);
            this.jobsUsage = Objects.requireNonNull(jobsUsage);
            this.datafeedsUsage = Objects.requireNonNull(datafeedsUsage);
        }

        public Usage(StreamInput in) throws IOException {
            super(in);
            this.jobsUsage = in.readMap();
            this.datafeedsUsage = in.readMap();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.jobsUsage);
            out.writeMap(this.datafeedsUsage);
        }

        @Override
        protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.innerXContent(builder, params);
            if (this.jobsUsage != null) {
                builder.field(JOBS_FIELD, this.jobsUsage);
            }
            if (this.datafeedsUsage != null) {
                builder.field(DATAFEEDS_FIELD, this.datafeedsUsage);
            }
        }

        public static class Retriever {
            private final Client client;
            private final MlMetadata mlMetadata;
            private final boolean available;
            private final boolean enabled;
            private Map<String, Object> jobsUsage;
            private Map<String, Object> datafeedsUsage;

            public Retriever(Client client, MlMetadata mlMetadata, boolean available, boolean enabled) {
                this.client = Objects.requireNonNull(client);
                this.mlMetadata = mlMetadata;
                this.available = available;
                this.enabled = enabled;
                this.jobsUsage = new LinkedHashMap<String, Object>();
                this.datafeedsUsage = new LinkedHashMap<String, Object>();
            }

            public void execute(ActionListener<XPackFeatureSet.Usage> listener) {
                if (!this.enabled) {
                    listener.onResponse((Object)new Usage(this.available, this.enabled, Collections.emptyMap(), Collections.emptyMap()));
                    return;
                }
                ActionListener datafeedStatsListener = ActionListener.wrap(response -> {
                    this.addDatafeedsUsage((GetDatafeedsStatsAction.Response)((Object)response));
                    listener.onResponse((Object)new Usage(this.available, this.enabled, this.jobsUsage, this.datafeedsUsage));
                }, error -> listener.onFailure(error));
                GetJobsStatsAction.Request jobStatsRequest = new GetJobsStatsAction.Request(Usage.ALL);
                ActionListener jobStatsListener = ActionListener.wrap(response -> {
                    this.addJobsUsage((GetJobsStatsAction.Response)((Object)response));
                    GetDatafeedsStatsAction.Request datafeedStatsRequest = new GetDatafeedsStatsAction.Request(Usage.ALL);
                    this.client.execute((Action)GetDatafeedsStatsAction.INSTANCE, (ActionRequest)datafeedStatsRequest, datafeedStatsListener);
                }, error -> listener.onFailure(error));
                this.client.execute((Action)GetJobsStatsAction.INSTANCE, (ActionRequest)jobStatsRequest, jobStatsListener);
            }

            private void addJobsUsage(GetJobsStatsAction.Response response) {
                StatsAccumulator allJobsDetectorsStats = new StatsAccumulator();
                StatsAccumulator allJobsModelSizeStats = new StatsAccumulator();
                HashMap<JobState, Counter> jobCountByState = new HashMap<JobState, Counter>();
                HashMap<JobState, StatsAccumulator> detectorStatsByState = new HashMap<JobState, StatsAccumulator>();
                HashMap<JobState, StatsAccumulator> modelSizeStatsByState = new HashMap<JobState, StatsAccumulator>();
                Map<String, Job> jobs = this.mlMetadata.getJobs();
                List<GetJobsStatsAction.Response.JobStats> jobsStats = response.getResponse().results();
                for (GetJobsStatsAction.Response.JobStats jobStats : jobsStats) {
                    ModelSizeStats modelSizeStats = jobStats.getModelSizeStats();
                    int detectorsCount = jobs.get(jobStats.getJobId()).getAnalysisConfig().getDetectors().size();
                    double modelSize = modelSizeStats == null ? 0.0 : (double)jobStats.getModelSizeStats().getModelBytes();
                    allJobsDetectorsStats.add(detectorsCount);
                    allJobsModelSizeStats.add(modelSize);
                    JobState jobState = jobStats.getState();
                    jobCountByState.computeIfAbsent(jobState, js -> Counter.newCounter()).addAndGet(1L);
                    detectorStatsByState.computeIfAbsent(jobState, js -> new StatsAccumulator()).add(detectorsCount);
                    modelSizeStatsByState.computeIfAbsent(jobState, js -> new StatsAccumulator()).add(modelSize);
                }
                this.jobsUsage.put(Usage.ALL, this.createJobUsageEntry(jobs.size(), allJobsDetectorsStats, allJobsModelSizeStats));
                for (JobState jobState : jobCountByState.keySet()) {
                    this.jobsUsage.put(jobState.name().toLowerCase(Locale.ROOT), this.createJobUsageEntry(((Counter)jobCountByState.get((Object)jobState)).get(), (StatsAccumulator)detectorStatsByState.get((Object)jobState), (StatsAccumulator)modelSizeStatsByState.get((Object)jobState)));
                }
            }

            private Map<String, Object> createJobUsageEntry(long count, StatsAccumulator detectorStats, StatsAccumulator modelSizeStats) {
                HashMap<String, Object> usage = new HashMap<String, Object>();
                usage.put(Usage.COUNT, count);
                usage.put(Usage.DETECTORS, detectorStats.asMap());
                usage.put(Usage.MODEL_SIZE, modelSizeStats.asMap());
                return usage;
            }

            private void addDatafeedsUsage(GetDatafeedsStatsAction.Response response) {
                HashMap<DatafeedState, Counter> datafeedCountByState = new HashMap<DatafeedState, Counter>();
                List<GetDatafeedsStatsAction.Response.DatafeedStats> datafeedsStats = response.getResponse().results();
                for (GetDatafeedsStatsAction.Response.DatafeedStats datafeedStats : datafeedsStats) {
                    datafeedCountByState.computeIfAbsent(datafeedStats.getDatafeedState(), ds -> Counter.newCounter()).addAndGet(1L);
                }
                this.datafeedsUsage.put(Usage.ALL, this.createDatafeedUsageEntry(response.getResponse().count()));
                for (DatafeedState datafeedState : datafeedCountByState.keySet()) {
                    this.datafeedsUsage.put(datafeedState.name().toLowerCase(Locale.ROOT), this.createDatafeedUsageEntry(((Counter)datafeedCountByState.get((Object)datafeedState)).get()));
                }
            }

            private Map<String, Object> createDatafeedUsageEntry(long count) {
                HashMap<String, Object> usage = new HashMap<String, Object>();
                usage.put(Usage.COUNT, count);
                return usage;
            }
        }
    }
}

