/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.ml.InvalidLicenseEnforcer;
import org.elasticsearch.xpack.ml.MachineLearningFeatureSet;
import org.elasticsearch.xpack.ml.MachineLearningTemplateRegistry;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.MlInitializationService;
import org.elasticsearch.xpack.ml.MlLifeCycleService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.CloseJobAction;
import org.elasticsearch.xpack.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.action.DeleteFilterAction;
import org.elasticsearch.xpack.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.ml.action.DeleteModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.ml.action.FlushJobAction;
import org.elasticsearch.xpack.ml.action.GetBucketsAction;
import org.elasticsearch.xpack.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.ml.action.GetInfluencersAction;
import org.elasticsearch.xpack.ml.action.GetJobsAction;
import org.elasticsearch.xpack.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.action.GetRecordsAction;
import org.elasticsearch.xpack.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.ml.action.KillProcessAction;
import org.elasticsearch.xpack.ml.action.OpenJobAction;
import org.elasticsearch.xpack.ml.action.PostDataAction;
import org.elasticsearch.xpack.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.ml.action.PutFilterAction;
import org.elasticsearch.xpack.ml.action.PutJobAction;
import org.elasticsearch.xpack.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.ml.action.UpdateModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.ml.action.ValidateDetectorAction;
import org.elasticsearch.xpack.ml.action.ValidateJobConfigAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJobBuilder;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.UpdateJobProcessNotifier;
import org.elasticsearch.xpack.ml.job.config.JobTaskStatus;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.NativeController;
import org.elasticsearch.xpack.ml.job.process.NativeControllerHolder;
import org.elasticsearch.xpack.ml.job.process.ProcessCtrl;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.BlackHoleAutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.NativeAutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.MultiplyingNormalizerProcess;
import org.elasticsearch.xpack.ml.job.process.normalizer.NativeNormalizerProcessFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcessFactory;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.ml.rest.RestDeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestDeleteDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestGetDatafeedStatsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestGetDatafeedsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestPreviewDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestPutDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestStartDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestStopDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestUpdateDatafeedAction;
import org.elasticsearch.xpack.ml.rest.filter.RestDeleteFilterAction;
import org.elasticsearch.xpack.ml.rest.filter.RestGetFiltersAction;
import org.elasticsearch.xpack.ml.rest.filter.RestPutFilterAction;
import org.elasticsearch.xpack.ml.rest.job.RestCloseJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestDeleteJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestFlushJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestGetJobStatsAction;
import org.elasticsearch.xpack.ml.rest.job.RestGetJobsAction;
import org.elasticsearch.xpack.ml.rest.job.RestOpenJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestPostDataAction;
import org.elasticsearch.xpack.ml.rest.job.RestPostJobUpdateAction;
import org.elasticsearch.xpack.ml.rest.job.RestPutJobAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestDeleteModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestGetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestRevertModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestUpdateModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetBucketsAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetCategoriesAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetInfluencersAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetRecordsAction;
import org.elasticsearch.xpack.ml.rest.validate.RestValidateDetectorAction;
import org.elasticsearch.xpack.ml.rest.validate.RestValidateJobConfigAction;
import org.elasticsearch.xpack.persistent.CompletionPersistentTaskAction;
import org.elasticsearch.xpack.persistent.PersistentTaskParams;
import org.elasticsearch.xpack.persistent.PersistentTasksClusterService;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.persistent.PersistentTasksExecutor;
import org.elasticsearch.xpack.persistent.PersistentTasksExecutorRegistry;
import org.elasticsearch.xpack.persistent.PersistentTasksNodeService;
import org.elasticsearch.xpack.persistent.PersistentTasksService;
import org.elasticsearch.xpack.persistent.RemovePersistentTaskAction;
import org.elasticsearch.xpack.persistent.StartPersistentTaskAction;
import org.elasticsearch.xpack.persistent.UpdatePersistentTaskStatusAction;
import org.elasticsearch.xpack.security.InternalClient;

public class MachineLearning
implements ActionPlugin {
    public static final String NAME = "ml";
    public static final String BASE_PATH = "/_xpack/ml/";
    public static final String DATAFEED_THREAD_POOL_NAME = "ml_datafeed";
    public static final String AUTODETECT_THREAD_POOL_NAME = "ml_autodetect";
    public static final String UTILITY_THREAD_POOL_NAME = "ml_utility";
    public static final Setting<Boolean> AUTODETECT_PROCESS = Setting.boolSetting((String)"xpack.ml.autodetect_process", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> ML_ENABLED = Setting.boolSetting((String)"node.ml", XPackSettings.MACHINE_LEARNING_ENABLED, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final String ML_ENABLED_NODE_ATTR = "ml.enabled";
    public static final String MAX_OPEN_JOBS_NODE_ATTR = "ml.max_open_jobs";
    public static final Setting<Integer> CONCURRENT_JOB_ALLOCATIONS = Setting.intSetting((String)"xpack.ml.node_concurrent_job_allocations", (int)2, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final TimeValue STATE_PERSIST_RESTORE_TIMEOUT = TimeValue.timeValueMinutes((long)30L);
    private final Settings settings;
    private final Environment env;
    private final XPackLicenseState licenseState;
    private final boolean enabled;
    private final boolean transportClientMode;
    private final boolean tribeNode;
    private final boolean tribeNodeClient;

    public MachineLearning(Settings settings, Environment env, XPackLicenseState licenseState) {
        this.settings = settings;
        this.env = env;
        this.licenseState = licenseState;
        this.enabled = (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(settings);
        this.transportClientMode = XPackPlugin.transportClientMode(settings);
        this.tribeNode = XPackPlugin.isTribeNode(settings);
        this.tribeNodeClient = XPackPlugin.isTribeClientNode(settings);
    }

    public List<Setting<?>> getSettings() {
        return Collections.unmodifiableList(Arrays.asList(AUTODETECT_PROCESS, ML_ENABLED, CONCURRENT_JOB_ALLOCATIONS, ProcessCtrl.DONT_PERSIST_MODEL_STATE_SETTING, ProcessCtrl.MAX_ANOMALY_RECORDS_SETTING, DataCountsReporter.ACCEPTABLE_PERCENTAGE_DATE_PARSE_ERRORS_SETTING, DataCountsReporter.ACCEPTABLE_PERCENTAGE_OUT_OF_ORDER_ERRORS_SETTING, AutodetectProcessManager.MAX_RUNNING_JOBS_PER_NODE));
    }

    public Settings additionalSettings() {
        if (!this.enabled || this.transportClientMode || this.tribeNode || this.tribeNodeClient) {
            return Settings.EMPTY;
        }
        Settings.Builder additionalSettings = Settings.builder();
        Boolean allocationEnabled = (Boolean)ML_ENABLED.get(this.settings);
        if (allocationEnabled != null && allocationEnabled.booleanValue()) {
            additionalSettings.put("node.attr.ml.enabled", "true");
            additionalSettings.put("node.attr.ml.max_open_jobs", ((Integer)AutodetectProcessManager.MAX_RUNNING_JOBS_PER_NODE.get(this.settings)).intValue());
        }
        return additionalSettings.build();
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry(MetaData.Custom.class, NAME, MlMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, NAME, MlMetadata.MlMetadataDiff::new), new NamedWriteableRegistry.Entry(MetaData.Custom.class, "persistent_tasks", PersistentTasksCustomMetaData::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "persistent_tasks", PersistentTasksCustomMetaData::readDiffFrom), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/datafeed", StartDatafeedAction.DatafeedParams::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/job", OpenJobAction.JobParams::new), new NamedWriteableRegistry.Entry(Task.Status.class, "persistent_executor", PersistentTasksNodeService.Status::new), new NamedWriteableRegistry.Entry(Task.Status.class, "xpack/ml/job", JobTaskStatus::new), new NamedWriteableRegistry.Entry(Task.Status.class, "xpack/ml/datafeed", DatafeedState::fromStream));
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Arrays.asList(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField(NAME, new String[0]), parser -> ((MlMetadata.Builder)MlMetadata.METADATA_PARSER.parse(parser, null)).build()), new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("persistent_tasks", new String[0]), PersistentTasksCustomMetaData::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ml/datafeed", new String[0]), StartDatafeedAction.DatafeedParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ml/job", new String[0]), OpenJobAction.JobParams::fromXContent), new NamedXContentRegistry.Entry(Task.Status.class, new ParseField("xpack/ml/datafeed", new String[0]), DatafeedState::fromXContent), new NamedXContentRegistry.Entry(Task.Status.class, new ParseField("xpack/ml/job", new String[0]), JobTaskStatus::fromXContent));
    }

    public Collection<Object> createComponents(InternalClient internalClient, ClusterService clusterService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry) {
        NormalizerProcessFactory normalizerProcessFactory;
        AutodetectProcessFactory autodetectProcessFactory;
        if (!this.enabled || this.transportClientMode || this.tribeNode || this.tribeNodeClient) {
            return Collections.emptyList();
        }
        Auditor auditor = new Auditor((Client)internalClient, clusterService);
        JobProvider jobProvider = new JobProvider((Client)internalClient, this.settings);
        UpdateJobProcessNotifier notifier = new UpdateJobProcessNotifier(this.settings, (Client)internalClient, clusterService, threadPool);
        JobManager jobManager = new JobManager(this.settings, jobProvider, clusterService, auditor, (Client)internalClient, notifier);
        JobDataCountsPersister jobDataCountsPersister = new JobDataCountsPersister(this.settings, (Client)internalClient);
        JobResultsPersister jobResultsPersister = new JobResultsPersister(this.settings, (Client)internalClient);
        if (((Boolean)AUTODETECT_PROCESS.get(this.settings)).booleanValue() && MachineLearningFeatureSet.isRunningOnMlPlatform(true)) {
            try {
                NativeController nativeController = NativeControllerHolder.getNativeController(this.settings);
                if (nativeController == null) {
                    throw new ElasticsearchException("Failed to create native process controller for Machine Learning", new Object[0]);
                }
                autodetectProcessFactory = new NativeAutodetectProcessFactory(jobProvider, this.env, this.settings, nativeController, (Client)internalClient);
                normalizerProcessFactory = new NativeNormalizerProcessFactory(this.env, this.settings, nativeController);
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to create native process factories for Machine Learning", (Throwable)e, new Object[0]);
            }
        } else {
            autodetectProcessFactory = (job, modelSnapshot, quantiles, filters, executorService, onProcessCrash) -> new BlackHoleAutodetectProcess(job.getId());
            normalizerProcessFactory = (jobId, quantilesState, bucketSpan, perPartitionNormalization, executorService) -> new MultiplyingNormalizerProcess(this.settings, 1.0);
        }
        NormalizerFactory normalizerFactory = new NormalizerFactory(normalizerProcessFactory, threadPool.executor(UTILITY_THREAD_POOL_NAME));
        AutodetectProcessManager autodetectProcessManager = new AutodetectProcessManager(this.settings, (Client)internalClient, threadPool, jobManager, jobProvider, jobResultsPersister, jobDataCountsPersister, autodetectProcessFactory, normalizerFactory, xContentRegistry, auditor);
        PersistentTasksService persistentTasksService = new PersistentTasksService(this.settings, clusterService, threadPool, internalClient);
        DatafeedJobBuilder datafeedJobBuilder = new DatafeedJobBuilder((Client)internalClient, jobProvider, auditor, System::currentTimeMillis);
        DatafeedManager datafeedManager = new DatafeedManager(threadPool, (Client)internalClient, clusterService, datafeedJobBuilder, System::currentTimeMillis, auditor, persistentTasksService);
        MlLifeCycleService mlLifeCycleService = new MlLifeCycleService(this.settings, clusterService, datafeedManager, autodetectProcessManager);
        InvalidLicenseEnforcer invalidLicenseEnforcer = new InvalidLicenseEnforcer(this.settings, this.licenseState, threadPool, datafeedManager, autodetectProcessManager);
        PersistentTasksExecutorRegistry persistentTasksExecutorRegistry = new PersistentTasksExecutorRegistry(Settings.EMPTY, Arrays.asList(new PersistentTasksExecutor[]{new OpenJobAction.OpenJobPersistentTasksExecutor(this.settings, clusterService, autodetectProcessManager), new StartDatafeedAction.StartDatafeedPersistentTasksExecutor(this.settings, datafeedManager)}));
        return Arrays.asList(new Object[]{mlLifeCycleService, jobProvider, jobManager, autodetectProcessManager, new MachineLearningTemplateRegistry(this.settings, clusterService, (Client)internalClient, threadPool), new MlInitializationService(this.settings, threadPool, clusterService, (Client)internalClient), jobDataCountsPersister, datafeedManager, persistentTasksService, persistentTasksExecutorRegistry, new PersistentTasksClusterService(Settings.EMPTY, persistentTasksExecutorRegistry, clusterService), auditor, invalidLicenseEnforcer, new MlAssignmentNotifier(this.settings, auditor, clusterService)});
    }

    public Collection<Module> nodeModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.tribeNodeClient || this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet(b, MachineLearningFeatureSet.class));
        return modules;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled || this.tribeNodeClient || this.tribeNode) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestGetJobsAction(settings, restController), new RestGetJobStatsAction(settings, restController), new RestPutJobAction(settings, restController), new RestPostJobUpdateAction(settings, restController), new RestDeleteJobAction(settings, restController), new RestOpenJobAction(settings, restController), new RestGetFiltersAction(settings, restController), new RestPutFilterAction(settings, restController), new RestDeleteFilterAction(settings, restController), new RestGetInfluencersAction(settings, restController), new RestGetRecordsAction(settings, restController), new RestGetBucketsAction(settings, restController), new RestPostDataAction(settings, restController), new RestCloseJobAction(settings, restController), new RestFlushJobAction(settings, restController), new RestValidateDetectorAction(settings, restController), new RestValidateJobConfigAction(settings, restController), new RestGetCategoriesAction(settings, restController), new RestGetModelSnapshotsAction(settings, restController), new RestRevertModelSnapshotAction(settings, restController), new RestUpdateModelSnapshotAction(settings, restController), new RestGetDatafeedsAction(settings, restController), new RestGetDatafeedStatsAction(settings, restController), new RestPutDatafeedAction(settings, restController), new RestUpdateDatafeedAction(settings, restController), new RestDeleteDatafeedAction(settings, restController), new RestPreviewDatafeedAction(settings, restController), new RestStartDatafeedAction(settings, restController), new RestStopDatafeedAction(settings, restController), new RestDeleteModelSnapshotAction(settings, restController), new RestDeleteExpiredDataAction(settings, restController)});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled || this.tribeNodeClient || this.tribeNode) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((GenericAction)GetJobsAction.INSTANCE, GetJobsAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetJobsStatsAction.INSTANCE, GetJobsStatsAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PutJobAction.INSTANCE, PutJobAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)UpdateJobAction.INSTANCE, UpdateJobAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteJobAction.INSTANCE, DeleteJobAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)OpenJobAction.INSTANCE, OpenJobAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetFiltersAction.INSTANCE, GetFiltersAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PutFilterAction.INSTANCE, PutFilterAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteFilterAction.INSTANCE, DeleteFilterAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)KillProcessAction.INSTANCE, KillProcessAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetBucketsAction.INSTANCE, GetBucketsAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetInfluencersAction.INSTANCE, GetInfluencersAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetRecordsAction.INSTANCE, GetRecordsAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PostDataAction.INSTANCE, PostDataAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)CloseJobAction.INSTANCE, CloseJobAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)FinalizeJobExecutionAction.INSTANCE, FinalizeJobExecutionAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)FlushJobAction.INSTANCE, FlushJobAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)ValidateDetectorAction.INSTANCE, ValidateDetectorAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)ValidateJobConfigAction.INSTANCE, ValidateJobConfigAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetCategoriesAction.INSTANCE, GetCategoriesAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetModelSnapshotsAction.INSTANCE, GetModelSnapshotsAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)RevertModelSnapshotAction.INSTANCE, RevertModelSnapshotAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)UpdateModelSnapshotAction.INSTANCE, UpdateModelSnapshotAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetDatafeedsAction.INSTANCE, GetDatafeedsAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetDatafeedsStatsAction.INSTANCE, GetDatafeedsStatsAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PutDatafeedAction.INSTANCE, PutDatafeedAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)UpdateDatafeedAction.INSTANCE, UpdateDatafeedAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteDatafeedAction.INSTANCE, DeleteDatafeedAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PreviewDatafeedAction.INSTANCE, PreviewDatafeedAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)StartDatafeedAction.INSTANCE, StartDatafeedAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)StopDatafeedAction.INSTANCE, StopDatafeedAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)IsolateDatafeedAction.INSTANCE, IsolateDatafeedAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteModelSnapshotAction.INSTANCE, DeleteModelSnapshotAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)StartPersistentTaskAction.INSTANCE, StartPersistentTaskAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)UpdatePersistentTaskStatusAction.INSTANCE, UpdatePersistentTaskStatusAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)CompletionPersistentTaskAction.INSTANCE, CompletionPersistentTaskAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)RemovePersistentTaskAction.INSTANCE, RemovePersistentTaskAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)UpdateProcessAction.INSTANCE, UpdateProcessAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteExpiredDataAction.INSTANCE, DeleteExpiredDataAction.TransportAction.class, new Class[0]));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (!this.enabled || this.tribeNode || this.tribeNodeClient || this.transportClientMode) {
            return Collections.emptyList();
        }
        int maxNumberOfJobs = (Integer)AutodetectProcessManager.MAX_RUNNING_JOBS_PER_NODE.get(settings);
        FixedExecutorBuilder autoDetect = new FixedExecutorBuilder(settings, AUTODETECT_THREAD_POOL_NAME, maxNumberOfJobs * 4, 4, "xpack.ml.autodetect_thread_pool");
        FixedExecutorBuilder renormalizer = new FixedExecutorBuilder(settings, UTILITY_THREAD_POOL_NAME, maxNumberOfJobs * 4, 500, "xpack.ml.utility_thread_pool");
        FixedExecutorBuilder datafeed = new FixedExecutorBuilder(settings, DATAFEED_THREAD_POOL_NAME, maxNumberOfJobs, 200, "xpack.ml.datafeed_thread_pool");
        return Arrays.asList(autoDetect, renormalizer, datafeed);
    }
}

