/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.xpack.deprecation.ClusterDeprecationChecks;
import org.elasticsearch.xpack.deprecation.DeprecationIssue;

public class NodeDeprecationChecks {
    static DeprecationIssue clusterNameNotAllowedInNodePathCheck(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        assert (nodeInfos.size() == nodeStats.size());
        nodeInfos.sort(Comparator.comparing(n -> n.getNode().getName()));
        nodeStats.sort(Comparator.comparing(n -> n.getNode().getName()));
        ClusterName clusterName = (ClusterName)ClusterName.CLUSTER_NAME_SETTING.get(nodeInfos.get(0).getSettings());
        for (int i = 0; i < nodeInfos.size(); ++i) {
            List dataPathsWithClusterName = ((List)Environment.PATH_DATA_SETTING.get(nodeInfos.get(i).getSettings())).stream().map(p -> p + "/" + clusterName.value()).collect(Collectors.toList());
            Iterator pathsIterator = nodeStats.get(i).getFs().iterator();
            while (pathsIterator.hasNext()) {
                String nodeDataPath = ((FsInfo.Path)pathsIterator.next()).getPath();
                for (String dataPathWithClusterName : dataPathsWithClusterName) {
                    if (!nodeDataPath.startsWith(dataPathWithClusterName)) continue;
                    return new DeprecationIssue(DeprecationIssue.Level.WARNING, "cluster name is no longer allowed in path.data", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_cluster_changes.html#_cluster_name_no_longer_allowed_in_path_data", null);
                }
            }
        }
        return null;
    }

    static DeprecationIssue pathConfNoLongerAllowed(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        ArrayList<String> nodesFound = new ArrayList<String>();
        for (NodeInfo info : nodeInfos) {
            if (info.getSettings().get("path.conf") == null) continue;
            nodesFound.add(info.getNode().getName());
        }
        if (nodesFound.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "path.conf is no longer a configurable setting", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_packaging_changes.html#_literal_path_conf_literal_is_no_longer_a_configurable_setting", "nodes with setting: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue bit32NotMaintained(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        ArrayList<String> nodesFound = new ArrayList<String>();
        for (NodeInfo info : nodeInfos) {
            if (info.getOs() == null || info.getOs().getArch().contains("64")) continue;
            nodesFound.add(info.getNode().getName());
        }
        if (nodesFound.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "32-bit is no longer maintained", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_packaging_changes.html#_32_bit_is_no_longer_maintained", "nodes running on non 64-bit architectures: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue defaultPathSettingsRemoved(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        ArrayList<String> nodesFound = new ArrayList<String>();
        for (NodeInfo info : nodeInfos) {
            if (info.getSettings().get("default.path.data") == null && info.getSettings().get("default.path.logs") == null) continue;
            nodesFound.add(info.getNode().getName());
        }
        if (nodesFound.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Default path settings are removed", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_packaging_changes.html#_default_path_settings_are_removed", "nodes with settings: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue scriptSettingsChanged(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        List<String> scriptTypes = Arrays.asList("inline", "stored", "file");
        List<String> contexts = Arrays.asList("search", "update", "plugin", "aggs");
        List deprecatedEngineSettings = scriptTypes.stream().flatMap(s -> contexts.stream().map(c -> s + "." + c)).collect(Collectors.toList());
        deprecatedEngineSettings.addAll(scriptTypes);
        List<String> deprecatedTopLevelSettings = Arrays.asList("script.inline", "script.stored", "script.file", "script.update", "script.plugin", "script.search", "script.aggs");
        ArrayList<String> nodesFound = new ArrayList<String>();
        for (NodeInfo info : nodeInfos) {
            List usedSettings = deprecatedTopLevelSettings.stream().filter(s -> info.getSettings().get(s) != null).collect(Collectors.toList());
            Set engineSettingsEntries = info.getSettings().getAsSettings("script.engine").getAsGroups().entrySet();
            for (Map.Entry engineSettingsEntry : engineSettingsEntries) {
                String engine = (String)engineSettingsEntry.getKey();
                Settings engineSettings = (Settings)engineSettingsEntry.getValue();
                deprecatedEngineSettings.stream().filter(s -> engineSettings.get(s) != null).forEach(s -> usedSettings.add("script.engine." + engine + "." + s));
            }
            if (usedSettings.size() <= 0) continue;
            nodesFound.add("node[" + info.getNode().getName() + "] used these script-security settings:" + usedSettings);
        }
        if (nodesFound.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Deprecated script security settings changes", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_settings_changes.html#_script_settings_2", ((Object)nodesFound).toString());
        }
        return null;
    }

    static DeprecationIssue discoverySettingsChanged(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        ArrayList<String> nodesFound = new ArrayList<String>();
        for (NodeInfo info : nodeInfos) {
            String discoveryType = info.getSettings().get("discovery.type");
            if (!"gce".equals(discoveryType) && !"aws".equals(discoveryType) && !"ec2".equals(discoveryType)) continue;
            nodesFound.add("node[" + info.getNode().getName() + "] is using discovery.type[" + discoveryType + "]");
        }
        if (nodesFound.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Discovery Setting type changes", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_settings_changes.html#_discovery_settings", "nodes with settings: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue pythonJavascriptPluginsRemoved(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        List nodesFound = nodeInfos.stream().filter(nodeInfo -> nodeInfo.getPlugins().getPluginInfos().stream().anyMatch(pluginInfo -> "lang-javascript".equals(pluginInfo.getName()) || "lang-python".equals(pluginInfo.getName()))).map(nodeInfo -> nodeInfo.getNode().getName()).collect(Collectors.toList());
        if (nodesFound.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Python and Javascript plugins are removed", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_scripting_changes.html#_groovy_javascript_and_python_languages_removed", "nodes with javascript or python plugins installed: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue s3RepositoryChanges(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        List nodesFound = nodeInfos.stream().filter(nodeInfo -> nodeInfo.getPlugins().getPluginInfos().stream().anyMatch(pluginInfo -> "repository-s3".equals(pluginInfo.getName()))).map(nodeInfo -> nodeInfo.getNode().getName()).collect(Collectors.toList());
        if (nodesFound.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "S3 Repository settings changed", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_plugins_changes.html#_s3_repository_plugin", "nodes with repository-s3 installed: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue azureRepositoryChanges(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        List nodesFound = nodeInfos.stream().filter(nodeInfo -> nodeInfo.getPlugins().getPluginInfos().stream().anyMatch(pluginInfo -> "repository-azure".equals(pluginInfo.getName()))).map(nodeInfo -> nodeInfo.getNode().getName()).collect(Collectors.toList());
        if (nodesFound.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Azure Repository settings changed", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_plugins_changes.html#_azure_repository_plugin", "nodes with repository-azure installed: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue gcsRepositoryChanges(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        List nodesFound = nodeInfos.stream().filter(nodeInfo -> nodeInfo.getPlugins().getPluginInfos().stream().anyMatch(pluginInfo -> "repository-gcs".equals(pluginInfo.getName()))).map(nodeInfo -> nodeInfo.getNode().getName()).collect(Collectors.toList());
        if (nodesFound.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "GCS repository `service_account` setting is removed", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_plugins_changes.html#_gcs_repository_plugin", "nodes with repository-gcs installed: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue ec2DiscoveryChanges(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        List nodesFound = nodeInfos.stream().filter(nodeInfo -> nodeInfo.getPlugins().getPluginInfos().stream().anyMatch(pluginInfo -> "discovery-ec2".equals(pluginInfo.getName()))).map(nodeInfo -> nodeInfo.getNode().getName()).collect(Collectors.toList());
        if (nodesFound.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "EC2 Discovery Plugin settings changed", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_plugins_changes.html#_ec2_discovery_plugin", "nodes with discovery-ec2 installed: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue snapshotSettingsCheck(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        ArrayList<String> nodesFound = new ArrayList<String>();
        DeprecationIssue lastIssue = null;
        for (NodeInfo info : nodeInfos) {
            DeprecationIssue issue = ClusterDeprecationChecks.snapshotSettingsCheck(info.getSettings());
            if (issue == null) continue;
            nodesFound.add(info.getNode().getName());
            lastIssue = issue;
        }
        if (nodesFound.size() > 0 && lastIssue != null) {
            return new DeprecationIssue(lastIssue.getLevel(), lastIssue.getMessage(), lastIssue.getUrl(), "nodes with setting: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue storeThrottlingSettingCheck(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        ArrayList<String> nodesFound = new ArrayList<String>();
        DeprecationIssue lastIssue = null;
        for (NodeInfo info : nodeInfos) {
            DeprecationIssue issue = ClusterDeprecationChecks.storeThrottlingSettingCheck(info.getSettings());
            if (issue == null) continue;
            nodesFound.add(info.getNode().getName());
            lastIssue = issue;
        }
        if (nodesFound.size() > 0 && lastIssue != null) {
            return new DeprecationIssue(lastIssue.getLevel(), lastIssue.getMessage(), lastIssue.getUrl(), lastIssue.getDetails() + ", nodes with setting: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue networkSettingCheck(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        ArrayList<String> nodesFound = new ArrayList<String>();
        DeprecationIssue lastIssue = null;
        for (NodeInfo info : nodeInfos) {
            DeprecationIssue issue = ClusterDeprecationChecks.networkSettingCheck(info.getSettings());
            if (issue == null) continue;
            nodesFound.add(info.getNode().getName());
            lastIssue = issue;
        }
        if (nodesFound.size() > 0 && lastIssue != null) {
            return new DeprecationIssue(lastIssue.getLevel(), lastIssue.getMessage(), lastIssue.getUrl(), lastIssue.getDetails() + ", nodes with setting: " + nodesFound);
        }
        return null;
    }

    static DeprecationIssue ingestNewDateFormatCheck(List<NodeInfo> nodeInfos, List<NodeStats> nodeStats) {
        ArrayList<String> nodesFound = new ArrayList<String>();
        DeprecationIssue lastIssue = null;
        for (NodeInfo info : nodeInfos) {
            DeprecationIssue issue = ClusterDeprecationChecks.ingestNewDateFormatCheck(info.getSettings());
            if (issue == null) continue;
            nodesFound.add(info.getNode().getName());
            lastIssue = issue;
        }
        if (nodesFound.size() > 0 && lastIssue != null) {
            return new DeprecationIssue(lastIssue.getLevel(), lastIssue.getMessage(), lastIssue.getUrl(), "nodes with setting: " + nodesFound);
        }
        return null;
    }
}

