/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.AllFieldMapper;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.xpack.deprecation.DeprecationIssue;

public class IndexDeprecationChecks {
    private static void fieldLevelMappingIssue(IndexMetaData indexMetaData, BiConsumer<MappingMetaData, Map<String, Object>> checker) {
        for (ObjectCursor mappingMetaData : indexMetaData.getMappings().values()) {
            Map sourceAsMap = ((MappingMetaData)mappingMetaData.value).sourceAsMap();
            checker.accept((MappingMetaData)mappingMetaData.value, sourceAsMap);
        }
    }

    private static List<String> findInPropertiesRecursively(String type, Map<String, Object> parentMap, Function<Map<?, ?>, Boolean> predicate) {
        ArrayList<String> issues = new ArrayList<String>();
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return issues;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (predicate.apply(valueMap).booleanValue()) {
                issues.add("[type: " + type + ", field: " + entry.getKey() + "]");
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (predicate.apply(multifieldValueMap).booleanValue()) {
                        issues.add("[type: " + type + ", field: " + entry.getKey() + ", multifield: " + multifieldEntry.getKey() + "]");
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, multifieldValueMap, predicate));
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, valueMap, predicate));
        }
        return issues;
    }

    static DeprecationIssue coercionCheck(IndexMetaData indexMetaData) {
        ArrayList issues = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetaData.type(), sourceAsMap, property -> "boolean".equals(property.get("type")))));
        if (issues.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.INFO, "Coercion of boolean fields", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_mappings_changes.html#_coercion_of_boolean_fields", ((Object)issues).toString());
        }
        return null;
    }

    static DeprecationIssue allMetaFieldIsDisabledByDefaultCheck(IndexMetaData indexMetaData) {
        ArrayList issues = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> {
            Map allMetaData = sourceAsMap.getOrDefault("_all", Collections.emptyMap());
            Object enabledObj = allMetaData.get("enabled");
            if (enabledObj != null) {
                enabledObj = Booleans.parseBoolean((String)enabledObj.toString(), (boolean)AllFieldMapper.Defaults.ENABLED.enabled);
            }
            if (Boolean.TRUE.equals(enabledObj)) {
                issues.add(mappingMetaData.type());
            }
        });
        if (issues.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.INFO, "The _all meta field is disabled by default on indices created in 6.0", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_mappings_changes.html#_the_literal__all_literal_meta_field_is_now_disabled_by_default", "types: " + ((Object)issues).toString());
        }
        return null;
    }

    static DeprecationIssue includeInAllCheck(IndexMetaData indexMetaData) {
        ArrayList issues = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetaData.type(), sourceAsMap, property -> property.containsKey("include_in_all"))));
        if (issues.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "The [include_in_all] mapping parameter is now disallowed", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_mappings_changes.html#_the_literal_include_in_all_literal_mapping_parameter_is_now_disallowed", ((Object)issues).toString());
        }
        return null;
    }

    static DeprecationIssue dynamicTemplateWithMatchMappingTypeCheck(IndexMetaData indexMetaData) {
        ArrayList issues = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> {
            List dynamicTemplates = mappingMetaData.getSourceAsMap().getOrDefault("dynamic_templates", Collections.emptyList());
            for (Object template : dynamicTemplates) {
                for (Map.Entry prop : ((Map)template).entrySet()) {
                    Map val = (Map)prop.getValue();
                    if (!val.containsKey("match_mapping_type")) continue;
                    Object mappingMatchType = val.get("match_mapping_type");
                    boolean isValidMatchType = Arrays.stream(DynamicTemplate.XContentFieldType.values()).anyMatch(v -> v.toString().equals(mappingMatchType));
                    if (isValidMatchType) continue;
                    issues.add("type: " + mappingMetaData.type() + ", dynamicFieldDefinition" + prop.getKey() + ", unknown match_mapping_type[" + mappingMatchType + "]");
                }
            }
        });
        if (issues.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Unrecognized match_mapping_type options not silently ignored", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_mappings_changes.html#_unrecognized_literal_match_mapping_type_literal_options_not_silently_ignored", ((Object)issues).toString());
        }
        return null;
    }

    static DeprecationIssue baseSimilarityDefinedCheck(IndexMetaData indexMetaData) {
        Settings settings = indexMetaData.getSettings().getAsSettings("index.similarity.base");
        if (settings.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "The base similarity is now ignored as coords and query normalization have been removed.If provided, this setting will be ignored and issue a deprecation warning", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_settings_changes.html#_similarity_settings", null);
        }
        return null;
    }

    static DeprecationIssue indexStoreTypeCheck(IndexMetaData indexMetaData) {
        if (indexMetaData.getSettings().get("index.store.type") != null) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "The default index.store.type has been removed. If you were using it, we advise that you simply remove it from your index settings and Elasticsearchwill use the best store implementation for your operating system.", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_settings_changes.html#_store_settings", null);
        }
        return null;
    }

    static DeprecationIssue storeThrottleSettingsCheck(IndexMetaData indexMetaData) {
        Settings settings = indexMetaData.getSettings();
        Settings throttleSettings = settings.getAsSettings("index.store.throttle");
        ArrayList<String> foundSettings = new ArrayList<String>();
        if (throttleSettings.get("max_bytes_per_sec") != null) {
            foundSettings.add("index.store.throttle.max_bytes_per_sec");
        }
        if (throttleSettings.get("type") != null) {
            foundSettings.add("index.store.throttle.type");
        }
        if (!foundSettings.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "index.store.throttle settings are no longer recognized. these settings should be removed", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_settings_changes.html#_store_throttling_settings", "present settings: " + foundSettings);
        }
        return null;
    }

    static DeprecationIssue indexSharedFileSystemCheck(IndexMetaData indexMetaData) {
        if (indexMetaData.getSettings().get("index.shared_filesystem") != null) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "[index.shared_filesystem] setting should be removed", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_indices_changes.html#_shadow_replicas_have_been_removed", null);
        }
        return null;
    }

    static DeprecationIssue oldIndicesCheck(IndexMetaData indexMetaData) {
        Version createdWith = indexMetaData.getCreationVersion();
        if (createdWith.before(Version.V_5_0_0)) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Index created before 5.0", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking-changes-6.0.html#_indices_created_before_6_0", "this index was created using version: " + createdWith);
        }
        return null;
    }

    static DeprecationIssue usesICUAnalysis(IndexMetaData indexMetaData) {
        ArrayList<String> details = new ArrayList<String>();
        Settings analysisSettings = indexMetaData.getSettings().getAsSettings("index.analysis");
        Map charFilters = analysisSettings.getAsSettings("char_filter").getAsGroups();
        for (Map.Entry charFilter : charFilters.entrySet()) {
            if (!"icu_normalizer".equals(((Settings)charFilter.getValue()).get("type"))) continue;
            details.add("defined char-filter[" + (String)charFilter.getKey() + "] is of type:icu_normalizer");
        }
        Map tokenFilters = analysisSettings.getAsSettings("filter").getAsGroups();
        for (Map.Entry entry : tokenFilters.entrySet()) {
            String filterType = ((Settings)entry.getValue()).get("type");
            if (!"icu_folding".equals(filterType) && !"icu_normalizer".equals(filterType) && !"icu_transform".equals(filterType)) continue;
            details.add("defined token-filter[" + (String)entry.getKey() + "] is of type:" + filterType);
        }
        Map analyzers = analysisSettings.getAsSettings("analyzer").getAsGroups();
        for (Map.Entry analyzer : analyzers.entrySet()) {
            for (String cf : ((Settings)analyzer.getValue()).getAsArray("char_filter")) {
                if (!"icu_normalizer".equals(cf)) continue;
                details.add("defined analyzer[" + (String)analyzer.getKey() + "] is using the icu_normalizer char_filter");
            }
            if ("icu_tokenizer".equals(((Settings)analyzer.getValue()).get("tokenizer"))) {
                details.add("defined analyzer[" + (String)analyzer.getKey() + "] is using the `icu_tokenizer` tokenizer");
            }
            for (String filter : ((Settings)analyzer.getValue()).getAsArray("filter")) {
                if (!"icu_normalizer".equals(filter) && !"icu_folding".equals(filter)) continue;
                details.add("defined analyzer[" + (String)analyzer.getKey() + "] is using the `" + filter + "` token filter");
            }
        }
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> {
            List<String> fieldOffenses = IndexDeprecationChecks.findInPropertiesRecursively(mappingMetaData.type(), sourceAsMap, property -> "icu_collation_keyword".equals(property.get("type")));
            if (fieldOffenses.size() > 0) {
                details.add("icu_collation_keyword typed field mappings: " + fieldOffenses);
            }
        });
        if (details.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Indexed with old ICU library version", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_plugins_changes.html#_icu_analysis_plugin", details.toString());
        }
        return null;
    }

    static DeprecationIssue synonmTokenFilter(IndexMetaData indexMetaData) {
        ArrayList<String> details = new ArrayList<String>();
        Settings analysisSettings = indexMetaData.getSettings().getAsSettings("index.analysis");
        Map tokenFilters = analysisSettings.getAsSettings("filter").getAsGroups();
        for (Map.Entry filter : tokenFilters.entrySet()) {
            List deprecatedFields;
            String filterType = ((Settings)filter.getValue()).get("type");
            if (!"synonym".equals(filterType) || (deprecatedFields = Arrays.asList("tokenizer", "ignore_case").stream().filter(field -> ((Settings)filter.getValue()).get(field) != null).collect(Collectors.toList())).size() <= 0) continue;
            details.add("synonym token filter [" + (String)filter.getKey() + "] is using deprecated fields" + deprecatedFields);
        }
        if (details.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Synonym token filter `tokenizer` and `ignore_case` parameters are deprecated", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_analysis_changes.html#_synonym_token_filter", details.toString());
        }
        return null;
    }

    static DeprecationIssue mapperAttachmentUsage(IndexMetaData indexMetaData) {
        ArrayList issues = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetaData.type(), sourceAsMap, property -> "attachment".equals(property.get("type")))));
        if (issues.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Mapper Attachment Plugin removed. use ingest-attachment plugin instead", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_plugins_changes.html#_mapper_attachments_plugin", "fields using mapper-attachment: " + issues);
        }
        return null;
    }
}

