/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.PutLicenseRequest;
import org.elasticsearch.license.PutLicenseResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.XPackClient;
import org.elasticsearch.xpack.rest.XPackRestHandler;

public class RestPutLicenseAction
extends XPackRestHandler {
    public RestPutLicenseAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/license", (RestHandler)this, RestRequest.Method.POST, "/_license", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, URI_BASE + "/license", (RestHandler)this, RestRequest.Method.PUT, "/_license", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_licenses", (RestHandler)this, "[POST /_licenses] is deprecated! Use [POST /_xpack/license] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.PUT, "/_licenses", (RestHandler)this, "[PUT /_licenses] is deprecated! Use [PUT /_xpack/license] instead.", this.deprecationLogger);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        PutLicenseRequest putLicenseRequest = new PutLicenseRequest();
        putLicenseRequest.license(request.content(), request.getXContentType());
        putLicenseRequest.acknowledge(request.paramAsBoolean("acknowledge", false));
        putLicenseRequest.timeout(request.paramAsTime("timeout", putLicenseRequest.timeout()));
        putLicenseRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putLicenseRequest.masterNodeTimeout()));
        return channel -> client.es().admin().cluster().execute((Action)PutLicenseAction.INSTANCE, (ActionRequest)putLicenseRequest, (ActionListener)new RestBuilderListener<PutLicenseResponse>(channel){

            public RestResponse buildResponse(PutLicenseResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                response.toXContent(builder, ToXContent.EMPTY_PARAMS);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

