/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.template.TemplateUtils;
import org.elasticsearch.xpack.watcher.support.init.proxy.WatcherClientProxy;

public class WatcherIndexTemplateRegistry
extends AbstractComponent
implements ClusterStateListener {
    private static final String FORBIDDEN_INDEX_SETTING = "index.mapper.dynamic";
    public static final String INDEX_TEMPLATE_VERSION = "3";
    public static final String HISTORY_TEMPLATE_NAME = "watch_history_3";
    public static final String TRIGGERED_TEMPLATE_NAME = "triggered_watches";
    public static final String WATCHES_TEMPLATE_NAME = "watches";
    public static final Setting<Settings> HISTORY_TEMPLATE_SETTING = Setting.groupSetting((String)"xpack.watcher.history.index.", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Settings> TRIGGERED_TEMPLATE_SETTING = Setting.groupSetting((String)"xpack.watcher.triggered_watches.index.", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Settings> WATCHES_TEMPLATE_SETTING = Setting.groupSetting((String)"xpack.watcher.watches.index.", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final TemplateConfig[] TEMPLATE_CONFIGS = new TemplateConfig[]{new TemplateConfig("triggered_watches", TRIGGERED_TEMPLATE_SETTING), new TemplateConfig("watch_history_3", "watch_history", HISTORY_TEMPLATE_SETTING), new TemplateConfig("watches", WATCHES_TEMPLATE_SETTING)};
    private final WatcherClientProxy client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TemplateConfig[] indexTemplates;
    private final ConcurrentMap<String, AtomicBoolean> templateCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();
    private volatile Map<String, Settings> customIndexSettings;

    @Inject
    public WatcherIndexTemplateRegistry(Settings settings, ClusterSettings clusterSettings, ClusterService clusterService, ThreadPool threadPool, InternalClient client) {
        super(settings);
        this.client = new WatcherClientProxy(settings, client);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indexTemplates = TEMPLATE_CONFIGS;
        clusterService.addListener((ClusterStateListener)this);
        HashMap<String, Settings> customIndexSettings = new HashMap<String, Settings>();
        for (TemplateConfig indexTemplate : this.indexTemplates) {
            clusterSettings.addSettingsUpdateConsumer(indexTemplate.getSetting(), s -> this.updateConfig(indexTemplate, (Settings)s));
            Settings customSettings = this.settings.getAsSettings(indexTemplate.getSetting().getKey());
            customIndexSettings.put(indexTemplate.getSetting().getKey(), customSettings);
        }
        this.customIndexSettings = Collections.unmodifiableMap(customIndexSettings);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (!event.localNodeMaster()) {
            return;
        }
        this.addTemplatesIfMissing(state, false);
    }

    public void addTemplatesIfMissing() {
        this.addTemplatesIfMissing(this.clusterService.state(), true);
    }

    void addTemplatesIfMissing(ClusterState state, boolean wait) {
        for (TemplateConfig template : this.indexTemplates) {
            String templateName = template.getTemplateName();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (!creationCheck.compareAndSet(false, true)) continue;
            if (!state.metaData().getTemplates().containsKey((Object)templateName)) {
                this.logger.debug("adding index template [{}], because it doesn't exist", (Object)templateName);
                this.putTemplate(template, creationCheck, wait);
                continue;
            }
            creationCheck.set(false);
            this.logger.trace("not adding index template [{}], because it already exists", (Object)templateName);
        }
    }

    private void updateConfig(TemplateConfig config, Settings settings) {
        if (!this.clusterService.localNode().isMasterNode()) {
            return;
        }
        if (settings.names().isEmpty()) {
            return;
        }
        Settings existingSettings = this.customIndexSettings.get(config.getSetting().getKey());
        if (existingSettings == null) {
            existingSettings = Settings.EMPTY;
        }
        boolean changed = false;
        Settings.Builder builder = Settings.builder().put(existingSettings);
        for (Map.Entry newSettingsEntry : settings.getAsMap().entrySet()) {
            String currentValue;
            String name = "index." + (String)newSettingsEntry.getKey();
            if (FORBIDDEN_INDEX_SETTING.equals(name)) {
                this.logger.warn("overriding the default [{}} setting is forbidden. ignoring...", (Object)name);
                continue;
            }
            String newValue = (String)newSettingsEntry.getValue();
            if (newValue.equals(currentValue = existingSettings.get(name))) continue;
            changed = true;
            builder.put(name, newValue);
            this.logger.info("changing setting [{}] from [{}] to [{}]", (Object)name, (Object)currentValue, (Object)newValue);
        }
        if (changed) {
            HashMap<String, Settings> customIndexSettings = new HashMap<String, Settings>(this.customIndexSettings);
            customIndexSettings.put(config.getSetting().getKey(), builder.build());
            this.customIndexSettings = customIndexSettings;
            this.putTemplate(config, this.templateCreationsInProgress.computeIfAbsent(config.getTemplateName(), key -> new AtomicBoolean(true)), false);
        }
    }

    private void putTemplate(TemplateConfig config, final AtomicBoolean creationCheck, boolean wait) {
        Executor executor = wait ? Runnable::run : this.threadPool.generic();
        executor.execute(() -> {
            final String templateName = config.getTemplateName();
            byte[] template = TemplateUtils.loadTemplate("/" + config.getFileName() + ".json", INDEX_TEMPLATE_VERSION, Pattern.quote("${xpack.watcher.template.version}")).getBytes(StandardCharsets.UTF_8);
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateName).source(template, XContentType.JSON);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            Settings customSettings = this.customIndexSettings.get(config.getSetting().getKey());
            if (customSettings != null && customSettings.names().size() > 0) {
                Settings updatedSettings = Settings.builder().put(request.settings()).put(customSettings).build();
                request.settings(updatedSettings);
            }
            this.client.putTemplate(request, new ActionListener<PutIndexTemplateResponse>(){

                public void onResponse(PutIndexTemplateResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        WatcherIndexTemplateRegistry.this.logger.error("Error adding watcher template [{}], request was not acknowledged", (Object)templateName);
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    WatcherIndexTemplateRegistry.this.logger.error((Message)new ParameterizedMessage("Error adding watcher template [{}]", (Object)templateName), (Throwable)e);
                }
            });
        });
    }

    public static class TemplateConfig {
        private final String templateName;
        private String fileName;
        private final Setting<Settings> setting;

        public TemplateConfig(String templateName, Setting<Settings> setting) {
            this(templateName, templateName, setting);
        }

        public TemplateConfig(String templateName, String fileName, Setting<Settings> setting) {
            this.templateName = templateName;
            this.fileName = fileName;
            this.setting = setting;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public Setting<Settings> getSetting() {
            return this.setting;
        }
    }
}

